/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.qualifier.Reversed;
import org.jdbi.v3.core.qualifier.ReversedStringArgumentFactory;
import org.jdbi.v3.core.qualifier.ReversedStringMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestFunctionArgument {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Spiffy dao;
    List<Something> expected;

    @BeforeEach
    public void setup() {
        Something one = new Something(3, "foo");
        Something two = new Something(4, "bar");
        Something thr = new Something(5, "baz");
        this.dao = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        this.dao.insert(one);
        this.dao.insert(thr);
        this.dao.insert(two);
        this.expected = Arrays.asList(thr, two, one);
    }

    @Test
    public void mapIterator() {
        List<Something> results = this.dao.mapIterator(Lists::newArrayList);
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
    }

    @Test
    public void mapIterable() {
        List<Something> results = this.dao.mapIterable(Lists::newArrayList);
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
    }

    @Test
    public void mapStream() {
        List<Something> results = this.dao.mapStream(stream -> stream.collect(Collectors.toList()));
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
    }

    @Test
    public void mapElement() {
        List<Something> results = this.dao.mapElement(4, stream -> stream.collect(Collectors.toList()));
        Assertions.assertThat(results).containsOnly((Object[])new Something[]{new Something(4, "bar")});
    }

    @Test
    public void mapIterableTwice() {
        ArrayList results2 = new ArrayList();
        List<Something> results = this.dao.mapIterable(it -> {
            ArrayList r = Lists.newArrayList((Iterable)it);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> it.forEach(results2::add)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("stream has already been operated upon or closed");
            return r;
        });
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
        Assertions.assertThat(results2).isEmpty();
    }

    @Test
    public void mapIterableIteratorTwice() {
        ArrayList results2 = new ArrayList();
        List<Something> results = this.dao.mapIterable(it -> {
            ArrayList r = Lists.newArrayList(it.iterator());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> it.iterator().forEachRemaining(results2::add)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("stream has already been operated upon or closed");
            return r;
        });
        Assertions.assertThat(results).containsExactlyElementsOf(this.expected);
        Assertions.assertThat(results2).isEmpty();
    }

    @Test
    public void testIteratorPartialConsumeOk() {
        List<Something> results = this.dao.mapIterator(iter -> Collections.singletonList((Something)iter.next()));
        Assertions.assertThat(results).containsExactly((Object[])new Something[]{this.expected.get(0)});
    }

    @Test
    public void testStreamPartialConsumeOk() {
        List<Something> results = this.dao.mapStream(stream -> Collections.singletonList(stream.findFirst().orElse(null)));
        Assertions.assertThat(results).containsExactly((Object[])new Something[]{this.expected.get(0)});
    }

    @Test
    public void testSubclassIteratorFails() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(ResultIteratorDao.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testSubclassStreamFails() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(SpecialStreamDao.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testConcreteStreamFails() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(SomethingStreamDao.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testAnnotation() {
        List<String> result = this.dao.streamReverse(s -> s.collect(Collectors.toList()));
        Assertions.assertThat(result).containsExactly((Object[])new String[]{"zab", "rab", "oof"});
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    public static interface Spiffy {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select name from something order by id desc")
        public List<String> streamReverse(@Reversed Function<Stream<String>, List<String>> var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public List<Something> mapStream(Function<Stream<Something>, List<Something>> var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public List<Something> mapIterator(Function<Iterator<Something>, List<Something>> var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public List<Something> mapIterable(Function<Iterable<Something>, List<Something>> var1);

        @SqlQuery(value="select * from something where id = :id")
        @RegisterRowMapper(value=SomethingMapper.class)
        public List<Something> mapElement(@Bind(value="id") int var1, Function<Stream<Something>, List<Something>> var2);
    }

    public static interface SomethingStreamDao {
        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public List<Something> mapStream(Function<SomethingStream, List<Something>> var1);
    }

    public static interface SpecialStreamDao {
        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public List<Something> mapStream(Function<SpecialStream<Something>, List<Something>> var1);
    }

    public static interface ResultIteratorDao {
        @SqlQuery(value="select id, name from something order by id desc")
        @RegisterRowMapper(value=SomethingMapper.class)
        public List<Something> mapIterator(Function<ResultIterator<Something>, List<Something>> var1);
    }

    public static interface SpecialStream<T>
    extends Stream<T> {
    }

    public static interface SomethingStream
    extends Stream<Something> {
    }
}

