/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Iterator;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.h2.jdbc.JdbcSQLNonTransientException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class TestIterator {
    static final Something ONE = new Something(3, "foo");
    static final Something TWO = new Something(4, "bar");
    static final Something THREE = new Something(5, "baz");
    @RegisterExtension
    JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle handle;
    Jdbi jdbi;

    TestIterator() {
    }

    @BeforeEach
    void setUp() {
        this.jdbi = this.h2Extension.getJdbi();
        this.handle = this.h2Extension.getSharedHandle();
        this.insert(ONE);
        this.insert(TWO);
        this.insert(THREE);
    }

    private void insert(Something something) {
        try (Update update = this.handle.createUpdate("INSERT INTO something (id, name) VALUES (:id, :name)");){
            ((Update)update.bindBean((Object)something)).execute();
        }
    }

    private void assertResourcesClosed(ThrowableAssert.ThrowingCallable callable) {
        ((ThrowableAssertAlternative)Assertions.assertThatExceptionOfType(ResultSetException.class).isThrownBy(callable).withMessageContaining("Unable to advance result set").havingCause().isInstanceOf(JdbcSQLNonTransientException.class)).hasFieldOrPropertyWithValue("errorCode", (Object)90007);
    }

    @Test
    void testAttachResultIteratorExhaust() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        try (ResultIterator<Something> it = dao.resultIterator();){
            Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
        }
    }

    @Test
    void testAttachResultIteratorSneaky() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        try (ResultIterator<Something> it = dao.sneakyIterator();){
            Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
        }
    }

    @Test
    void testAttachIteratorExhaust() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        Iterator<Something> it = dao.iterator();
        Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
    }

    @Test
    void testAttachIteratorLeak() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        Iterator<Something> it = dao.iterator();
        Assertions.assertThat(it).hasNext();
        Assertions.assertThat((Object)it.next()).isEqualTo((Object)THREE);
    }

    @Test
    void testAttachIteratorCallbackExhaust() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        dao.iterator(it -> Assertions.assertThat((Iterator)it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE}));
    }

    @Test
    void testAttachIteratorCallbackLeak() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        dao.iterator(it -> {
            Assertions.assertThat((Iterator)it).hasNext();
            Assertions.assertThat((Object)((Something)it.next())).isEqualTo((Object)THREE);
        });
    }

    @Test
    void testOnDemandResultIteratorExhaustFails() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        this.assertResourcesClosed(() -> {
            try (ResultIterator<Something> it = dao.resultIterator();){
                Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testOnDemandIteratorExhaustFails() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        this.assertResourcesClosed(() -> {
            ResultIterator<Something> it = dao.resultIterator();
            Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
        });
    }

    @Test
    void testOnDemandResultIteratorSneakyFails() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        this.assertResourcesClosed(() -> {
            try (ResultIterator<Something> it = dao.sneakyIterator();){
                Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testOnDemandIteratorWrapped() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.iteratorTester();
    }

    @Test
    void testOnDemandResultIteratorWrapped() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.resultIteratorTester();
    }

    @Test
    void testOnDemandIteratorWrappedLeak() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.iteratorLeakTester();
    }

    @Test
    void testOnDemandIteratorCallbackExhaust() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.iterator(it -> Assertions.assertThat((Iterator)it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE}));
    }

    @Test
    void testOnDemandIteratorCallbackLeak() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.iterator(it -> {
            Assertions.assertThat((Iterator)it).hasNext();
            Assertions.assertThat((Object)((Something)it.next())).isEqualTo((Object)THREE);
        });
    }

    @Test
    void testExtensionResultIteratorExhaust() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            try (ResultIterator<Something> it = dao.resultIterator();){
                Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testExtensionResultIteratorSneaky() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            try (ResultIterator<Something> it = dao.sneakyIterator();){
                Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testExtensionIteratorExhaust() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            Iterator<Something> it = dao.iterator();
            Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
        });
    }

    @Test
    void testExtensionIteratorLeak() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            Iterator<Something> it = dao.iterator();
            Assertions.assertThat(it).hasNext();
            Assertions.assertThat((Object)it.next()).isEqualTo((Object)THREE);
        });
    }

    @Test
    void testExtensionIteratorCallbackExhaust() {
        this.jdbi.useExtension(Spiffy.class, dao -> dao.iterator(it -> Assertions.assertThat((Iterator)it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE})));
    }

    @Test
    void testExtensionIteratorCallbackLeak() {
        this.jdbi.useExtension(Spiffy.class, dao -> dao.iterator(it -> {
            Assertions.assertThat((Iterator)it).hasNext();
            Assertions.assertThat((Object)((Something)it.next())).isEqualTo((Object)THREE);
        }));
    }

    @Test
    void testExtensionIteratorReturnFails() {
        this.assertResourcesClosed(() -> {
            try (ResultIterator it = (ResultIterator)this.jdbi.withExtension(Spiffy.class, Spiffy::resultIterator);){
                Assertions.assertThat((Iterator)it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something order by id desc")
        @UseRowMapper(value=SomethingMapper.class)
        public Iterator<Something> iterator();

        @SqlQuery(value="select id, name from something order by id desc")
        @UseRowMapper(value=SomethingMapper.class)
        public ResultIterator<Something> resultIterator();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @UseRowMapper(value=SomethingMapper.class)
        public void iterator(Consumer<Iterator<Something>> var1);

        default public void resultIteratorTester() {
            try (ResultIterator<Something> it = this.resultIterator();){
                Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        }

        default public void iteratorTester() {
            Iterator<Something> it = this.iterator();
            Assertions.assertThat(it).toIterable().containsExactly((Object[])new Something[]{THREE, TWO, ONE});
        }

        default public void iteratorLeakTester() {
            Iterator<Something> it = this.iterator();
            Assertions.assertThat(it).hasNext();
            Assertions.assertThat((Object)it.next()).isEqualTo((Object)THREE);
        }

        default public ResultIterator<Something> sneakyIterator() {
            return this.resultIterator();
        }
    }
}

