/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestMixinInterfaces {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Jdbi jdbi;

    @BeforeEach
    public void setUp() {
        this.jdbi = this.h2Extension.getJdbi();
        this.handle = this.h2Extension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testGetHandle() {
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        Handle h = g.getHandle();
        Assertions.assertThat((Object)h).isSameAs((Object)this.handle);
    }

    @Test
    public void testWithHandle() {
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        String name = (String)g.withHandle(h -> {
            h.execute("insert into something (id, name) values (8, 'Mike')", new Object[0]);
            return (String)h.createQuery("select name from something where id = 8").mapTo(String.class).one();
        });
        Assertions.assertThat((String)name).isEqualTo("Mike");
    }

    @Test
    public void testWithHandleExtensionMethod() throws Exception {
        Method withHandleMethod = SqlObject.class.getMethod("withHandle", HandleCallback.class);
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        String name = (String)g.withHandle(h -> {
            ExtensionMethod extensionMethod = this.handle.getExtensionMethod();
            Assertions.assertThat((Object)extensionMethod.getMethod()).isEqualTo((Object)withHandleMethod);
            return "Mike";
        });
        Assertions.assertThat((String)name).isEqualTo("Mike");
    }

    @Test
    public void testUseHandle() {
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        g.useHandle(h -> {
            h.execute("insert into something(id, name) values (9, 'James')", new Object[0]);
            Assertions.assertThat((String)((String)h.createQuery("select name from something where id = 9").mapTo(String.class).one())).isEqualTo("James");
        });
    }

    @Test
    public void testOverrideUseHandleFails() throws Exception {
        Method getHandleMethod = ExplicitUseHandle.class.getMethod("useHandle", HandleConsumer.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ExplicitUseHandle g = (ExplicitUseHandle)this.handle.attach(ExplicitUseHandle.class);
            g.useHandle(h -> {
                Assertions.assertThat((Object)h).isNotNull();
                Assertions.assertThat((Object)h.getExtensionMethod().getMethod()).isEqualTo((Object)getHandleMethod);
            });
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Method ExplicitUseHandle.useHandle has no registered extension handler!");
    }

    @Test
    public void testUseHandleExtensionMethod() throws Exception {
        Method withHandleMethod = SqlObject.class.getMethod("withHandle", HandleCallback.class);
        WithGetHandle g = (WithGetHandle)this.handle.attach(WithGetHandle.class);
        g.useHandle(h -> {
            ExtensionMethod extensionMethod = this.handle.getExtensionMethod();
            Assertions.assertThat((Object)extensionMethod.getMethod()).isEqualTo((Object)withHandleMethod);
        });
    }

    @Test
    public void testBeginAndCommitTransaction() {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        txl.insert(8L, "Mike");
        txl.begin();
        txl.updateName(8L, "Miker");
        Assertions.assertThat((String)txl.byId(8L).getName()).isEqualTo("Miker");
        txl.rollback();
        Assertions.assertThat((String)txl.byId(8L).getName()).isEqualTo("Mike");
    }

    @Test
    public void testInTransaction() {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        txl.insert(7L, "Keith");
        Something s = (Something)txl.inTransaction(h -> h.byId(7L));
        Assertions.assertThat((String)s.getName()).isEqualTo("Keith");
    }

    @Test
    public void testInTransactionWithLevel() {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        txl.insert(7L, "Keith");
        Something s = (Something)txl.inTransaction(TransactionIsolationLevel.SERIALIZABLE, conn -> {
            Assertions.assertThat((Comparable)conn.getHandle().getTransactionIsolationLevel()).isEqualTo((Object)TransactionIsolationLevel.SERIALIZABLE);
            return conn.byId(7L);
        });
        Assertions.assertThat((String)s.getName()).isEqualTo("Keith");
    }

    @Test
    public void testTransactionIsolationActuallyHappens() {
        TransactionStuff txl = (TransactionStuff)this.handle.attach(TransactionStuff.class);
        this.jdbi.useExtension(TransactionStuff.class, tx2 -> {
            txl.insert(8L, "Mike");
            txl.begin();
            txl.updateName(8L, "Miker");
            Assertions.assertThat((String)txl.byId(8L).getName()).isEqualTo("Miker");
            Assertions.assertThat((String)tx2.byId(8L).getName()).isEqualTo("Mike");
            txl.commit();
            Assertions.assertThat((String)tx2.byId(8L).getName()).isEqualTo("Miker");
        });
    }

    @Test
    public void testJustJdbiTransactions() {
        try (Handle h1 = this.jdbi.open();
             Handle h2 = this.jdbi.open();){
            h1.execute("insert into something (id, name) values (8, 'Mike')", new Object[0]);
            h1.begin();
            h1.execute("update something set name = 'Miker' where id = 8", new Object[0]);
            Assertions.assertThat((String)((String)h2.createQuery("select name from something where id = 8").mapTo(String.class).one())).isEqualTo("Mike");
            h1.commit();
        }
    }

    private static interface WithGetHandle
    extends SqlObject {
    }

    private static interface ExplicitUseHandle
    extends SqlObject {
        public void useHandle(HandleConsumer var1);
    }

    private static interface TransactionStuff
    extends Transactional<TransactionStuff> {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public void updateName(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

