/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.Connection;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.ConnectionException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindSomething;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestNewApiOnDbiAndHandle {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Jdbi jdbi;

    @BeforeEach
    public void setUp() {
        this.jdbi = this.h2Extension.getJdbi();
        this.handle = this.h2Extension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testOpenNewSpiffy() throws Exception {
        AtomicReference c = new AtomicReference();
        this.jdbi.useExtension(Spiffy.class, spiffy -> {
            spiffy.insert(new Something(1, "Tim"));
            spiffy.insert(new Something(2, "Diego"));
            Assertions.assertThat((String)spiffy.findNameById(2)).isEqualTo("Diego");
            c.set(spiffy.getHandle().getConnection());
        });
        Assertions.assertThat((boolean)((Connection)c.get()).isClosed()).isTrue();
    }

    @Test
    public void testOnDemandSpiffy() {
        Spiffy spiffy = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        spiffy.insert(new Something(1, "Tim"));
        spiffy.insert(new Something(2, "Diego"));
        Assertions.assertThat((String)spiffy.findNameById(2)).isEqualTo("Diego");
    }

    @Test
    public void testAttach() {
        Spiffy spiffy = (Spiffy)this.handle.attach(Spiffy.class);
        spiffy.insert(new Something(1, "Tim"));
        spiffy.insert(new Something(2, "Diego"));
        Assertions.assertThat((String)spiffy.findNameById(2)).isEqualTo("Diego");
    }

    @Test
    public void testCorrectExceptionIfUnableToConnectOnDemand() {
        Assertions.assertThatThrownBy(() -> ((Spiffy)Jdbi.create((String)"jdbc:mysql://invalid.invalid/test", (String)"john", (String)"scott").installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(Spiffy.class)).findNameById(1)).isInstanceOf(ConnectionException.class);
    }

    @Test
    public void testCorrectExceptionIfUnableToConnectOnOpen() {
        Assertions.assertThatThrownBy(() -> {
            try (Handle handle = Jdbi.create((String)"jdbc:mysql://invalid.invalid/test", (String)"john", (String)"scott").installPlugin((JdbiPlugin)new SqlObjectPlugin()).open();){
                handle.attach(Spiffy.class);
            }
        }).isInstanceOf(ConnectionException.class);
    }

    @Test
    public void testCorrectExceptionIfUnableToConnectOnAttach() {
        Assertions.assertThatThrownBy(() -> {
            try (Handle handle = Jdbi.create((String)"jdbc:mysql://invalid.invalid/test", (String)"john", (String)"scott").installPlugin((JdbiPlugin)new SqlObjectPlugin()).open();){
                handle.attach(Spiffy.class);
            }
        }).isInstanceOf(ConnectionException.class);
    }

    public static interface Spiffy
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:it.id, :it.name)")
        public void insert(@BindSomething(value="it") Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }
}

