/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestReadOnly {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testHandleReadOnly() throws Exception {
        try (Handle h = this.pgExtension.openHandle();){
            Assertions.assertThat((boolean)h.isReadOnly()).isFalse();
            Assertions.assertThat((boolean)h.getConnection().isReadOnly()).isFalse();
            h.setReadOnly(true);
            Assertions.assertThat((boolean)h.isReadOnly()).isTrue();
            Assertions.assertThat((boolean)h.getConnection().isReadOnly()).isTrue();
        }
    }

    @Test
    public void testSqlObjectReadOnly() throws Exception {
        try (Handle h = this.pgExtension.openHandle();){
            RODao dao = (RODao)h.attach(RODao.class);
            Assertions.assertThat((boolean)h.isReadOnly()).isFalse();
            Assertions.assertThat((boolean)dao.verifyReadOnly()).isTrue();
            Assertions.assertThat((boolean)h.isReadOnly()).isFalse();
        }
    }

    @Test
    public void testReadOnlyInner() {
        try (Handle h = this.pgExtension.openHandle();){
            RODao dao = (RODao)h.attach(RODao.class);
            dao.writeTxn(() -> {
                Assertions.assertThat((boolean)dao.getHandle().isReadOnly()).isFalse();
                dao.readTxn(() -> Assertions.assertThat((boolean)dao.getHandle().isReadOnly()).isTrue());
            });
        }
    }

    @Test
    public void testReadOnlyOuter() {
        try (Handle h = this.pgExtension.openHandle();){
            RODao dao = (RODao)h.attach(RODao.class);
            Assertions.assertThatThrownBy(() -> dao.readTxn(() -> dao.writeTxn(() -> {}))).isInstanceOf(TransactionException.class);
        }
    }

    private static interface RODao
    extends SqlObject {
        @Transaction(readOnly=true)
        default public boolean verifyReadOnly() throws SQLException {
            Handle h = this.getHandle();
            if (h.isReadOnly() != h.getConnection().isReadOnly()) {
                throw new AssertionError((Object)"didn't set");
            }
            return h.isReadOnly();
        }

        @Transaction(readOnly=false)
        default public void writeTxn(Runnable r) {
            Assertions.assertThat((boolean)this.getHandle().isReadOnly()).isFalse();
            r.run();
        }

        @Transaction(readOnly=true)
        default public void readTxn(Runnable r) {
            Assertions.assertThat((boolean)this.getHandle().isReadOnly()).isTrue();
            r.run();
        }
    }
}

