/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.junit5.H2DatabaseExtension;
import org.jdbi.v3.core.mapper.JoinRow;
import org.jdbi.v3.core.mapper.JoinRowMapperTest;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterJoinRowMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestRegisterJoinRowMapper {
    @RegisterExtension
    public H2DatabaseExtension h2Extension = H2DatabaseExtension.instance().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @BeforeEach
    public void setUp() {
        JoinRowMapperTest t = new JoinRowMapperTest();
        t.h2Extension = this.h2Extension;
        t.setUp();
    }

    @Test
    public void testSqlObjectJoinRow() {
        Handle handle = this.h2Extension.getSharedHandle();
        HashMultimap joined = HashMultimap.create();
        ((UserArticleDao)handle.attach(UserArticleDao.class)).getAuthorship().forEach(arg_0 -> TestRegisterJoinRowMapper.lambda$testSqlObjectJoinRow$0((Multimap)joined, arg_0));
        Assertions.assertThat((Object)joined).isEqualTo((Object)JoinRowMapperTest.getExpected());
    }

    private static /* synthetic */ void lambda$testSqlObjectJoinRow$0(Multimap joined, JoinRow jr) {
        joined.put((Object)((JoinRowMapperTest.User)jr.get(JoinRowMapperTest.User.class)), (Object)((JoinRowMapperTest.Article)jr.get(JoinRowMapperTest.Article.class)));
    }

    public static interface UserArticleDao {
        @RegisterJoinRowMapper(value={JoinRowMapperTest.User.class, JoinRowMapperTest.Article.class})
        @SqlQuery(value="SELECT * FROM \"user\" NATURAL JOIN author NATURAL JOIN article")
        public Stream<JoinRow> getAuthorship();
    }
}

