/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestSqlBatchWithCustomizer {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void test() {
        Handle h = this.h2Extension.getSharedHandle();
        h.execute("create table things (thing varchar)", new Object[0]);
        List<String> things = Arrays.asList("foo", "bar", "baz");
        ((ThingDAO)h.attach(ThingDAO.class)).batchInsertThings(things);
        Assertions.assertThat((List)h.createQuery("select thing from things").mapTo(String.class).list()).containsExactlyInAnyOrderElementsOf(things);
        Assertions.assertThat((AtomicInteger)VerifyImpl.INVOKED_COUNT).hasValue(things.size());
    }

    public static interface ThingDAO {
        @SqlBatch(value="insert into things (thing) values (:things)")
        @Verify
        public void batchInsertThings(@Bind List<String> var1);
    }

    public static class VerifyImpl
    implements StatementCustomizer {
        private static final AtomicInteger INVOKED_COUNT = new AtomicInteger(0);

        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) {
            INVOKED_COUNT.getAndIncrement();
        }
    }

    public static class VerifyFactory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return stmt -> stmt.addCustomizer((StatementCustomizer)new VerifyImpl());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @SqlStatementCustomizingAnnotation(value=VerifyFactory.class)
    public static @interface Verify {
    }
}

