/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestTransactionAnnotation {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testTx() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Something s = dao.insertAndFetch(1, "Ian");
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Ian"));
    }

    @Test
    public void testTxFail() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Throwable ex = Assertions.catchThrowable(() -> dao.fail(1, "Ian"));
        Assertions.assertThat((Throwable)ex).isInstanceOf(UncheckedIOException.class);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)ex.getCause()).isInstanceOf(IOException.class)).hasMessage("woof");
        Assertions.assertThat((Object)dao.findById(1)).isNull();
    }

    @Test
    public void testTxActuallyCommits() {
        try (Handle h2 = this.h2Extension.openHandle();){
            Dao one = (Dao)this.handle.attach(Dao.class);
            Dao two = (Dao)h2.attach(Dao.class);
            Something inserted = one.insertAndFetch(1, "Brian");
            Something fetched = two.findById(1);
            Assertions.assertThat((Object)fetched).isEqualTo((Object)inserted);
        }
    }

    @Test
    public void testConcurrent() throws Exception {
        ExecutorService es = Executors.newFixedThreadPool(3);
        CountDownLatch inserted = new CountDownLatch(1);
        CountDownLatch committed = new CountDownLatch(1);
        Other o = (Other)this.h2Extension.getJdbi().onDemand(Other.class);
        Future rf = es.submit(Unchecked.callable(() -> {
            o.insert(inserted, 1, "diwaker");
            committed.countDown();
            return null;
        }));
        Future tf = es.submit(Unchecked.callable(() -> {
            inserted.await();
            committed.await();
            Something s2 = o.find(1);
            Assertions.assertThat((Object)s2).isEqualTo((Object)new Something(1, "diwaker"));
            return null;
        }));
        rf.get();
        tf.get();
        es.shutdown();
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Dao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        @Transaction(value=TransactionIsolationLevel.READ_COMMITTED)
        default public Something insertAndFetch(int id, String name) {
            this.insert(id, name);
            return this.findById(id);
        }

        @Transaction
        default public Something fail(int id, String name) throws IOException {
            this.insert(id, name);
            throw new IOException("woof");
        }
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Other {
        @Transaction
        default public void insert(CountDownLatch inserted, int id, String name) {
            this.reallyInsert(id, name);
            inserted.countDown();
        }

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void reallyInsert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something find(@Bind(value="id") int var1);
    }
}

