/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.DefinedAttributeTemplateEngine;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.UseTemplateEngine;
import org.jdbi.v3.sqlobject.customizer.Definition;
import org.jdbi.v3.sqlobject.customizer.Definitions;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class DefinitionTest {
    @RegisterExtension
    public static final JdbiExtension DB = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    void definition() {
        DefinitionDao defnDao = (DefinitionDao)DB.getSharedHandle().attach(DefinitionDao.class);
        Assertions.assertThat((int)defnDao.select()).isEqualTo(42);
    }

    @UseTemplateEngine(value=DefinedAttributeTemplateEngine.class)
    @Definitions(value={@Definition(key="TYPE_DEFN", value="2"), @Definition(key="TYPE_DEFN_2", value="1")})
    public static interface DefinitionDao
    extends SuperDefinition1,
    SuperDefinition2 {
        @Definition
        public static String staticMethod() {
            return "sel";
        }

        @SqlQuery(value="<staticMethod><superStaticMethod> <STATIC_CONSTANT> + <TYPE_DEFN> + <TYPE_DEFN_2> + <SUPER_TYPE_DEFN>")
        public int select();
    }

    @Definition(key="SUPER_TYPE_DEFN", value="3")
    public static interface SuperDefinition2 {
        @Definition
        public static String superStaticMethod() {
            return "ect";
        }
    }

    public static interface SuperDefinition1 {
        @Definition
        public static final int STATIC_CONSTANT = 36;
    }
}

