/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.ObjectArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.sqlobject.config.RegisterObjectArgumentFactories;
import org.jdbi.v3.sqlobject.config.RegisterObjectArgumentFactory;

public class RegisterObjectArgumentFactoriesImpl
extends SimpleExtensionConfigurer {
    private final List<ArgumentFactory> argumentFactories;

    public RegisterObjectArgumentFactoriesImpl(Annotation annotation) {
        RegisterObjectArgumentFactories registerObjectArgumentFactories = (RegisterObjectArgumentFactories)annotation;
        this.argumentFactories = new ArrayList<ArgumentFactory>(registerObjectArgumentFactories.value().length);
        for (RegisterObjectArgumentFactory registerObjectArgumentFactory : registerObjectArgumentFactories.value()) {
            Class<?> klass = registerObjectArgumentFactory.value();
            int sqlType = registerObjectArgumentFactory.sqlType();
            try {
                if (sqlType == Integer.MIN_VALUE) {
                    this.argumentFactories.add(ObjectArgumentFactory.create(klass));
                    continue;
                }
                this.argumentFactories.add(ObjectArgumentFactory.create(klass, (Integer)sqlType));
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Unable to instantiate column mapper class " + String.valueOf(klass), e);
            }
        }
    }

    public void configure(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        Arguments arguments = (Arguments)config.get(Arguments.class);
        this.argumentFactories.forEach(arg_0 -> ((Arguments)arguments).register(arg_0));
    }
}

