/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.internal.BindListFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=BindListFactory.class)
public @interface BindList {
    public String value() default "";

    public EmptyHandling onEmpty() default EmptyHandling.THROW;

    public static enum EmptyHandling {
        VOID((stmt, name) -> stmt.define(name, (Object)"")),
        NULL((stmt, name) -> stmt.define(name, (Object)"null")),
        NULL_STRING((stmt, name) -> stmt.define(name, (Object)"null")),
        NULL_VALUE((stmt, name) -> stmt.define(name, null)),
        THROW((stmt, name) -> {
            throw new IllegalArgumentException("argument is null or empty; this was explicitly forbidden on this instance of BindList");
        });

        private final BiConsumer<SqlStatement, String> rendering;

        private EmptyHandling(BiConsumer<SqlStatement, String> rendering) {
            this.rendering = rendering;
        }

        public void define(SqlStatement stmt, String name) {
            this.rendering.accept(stmt, name);
        }
    }
}

