/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.testing.junit5.JdbiExtensionInitializer;

public final class JdbiFlywayMigration
implements JdbiExtensionInitializer {
    private final List<String> schemas = new ArrayList<String>();
    private final List<String> paths = new ArrayList<String>();
    private volatile boolean cleanAfter = true;
    private volatile Flyway flyway;

    public static JdbiFlywayMigration flywayMigration() {
        return new JdbiFlywayMigration();
    }

    private JdbiFlywayMigration() {
    }

    public JdbiFlywayMigration withDefaultPath() {
        this.paths.add("db/migration");
        return this;
    }

    public JdbiFlywayMigration withPath(String migrationPath) {
        Objects.requireNonNull(migrationPath, "migrationPath is null");
        this.paths.add(migrationPath);
        return this;
    }

    public JdbiFlywayMigration withPaths(String ... migrationPaths) {
        Arrays.asList(migrationPaths).forEach(this::withPath);
        return this;
    }

    public JdbiFlywayMigration withSchema(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        this.schemas.add(schema);
        return this;
    }

    public JdbiFlywayMigration withSchemas(String ... moreSchemas) {
        Arrays.asList(moreSchemas).forEach(this::withSchema);
        return this;
    }

    @Deprecated(since="3.35.0", forRemoval=true)
    public JdbiFlywayMigration cleanAfter() {
        this.cleanAfter = true;
        return this;
    }

    public JdbiFlywayMigration cleanAfter(boolean cleanAfter) {
        this.cleanAfter = cleanAfter;
        return this;
    }

    @Override
    public void initialize(DataSource ds, Handle handle) {
        this.flyway = Flyway.configure().dataSource(ds).locations(this.paths.toArray(new String[0])).schemas(this.schemas.toArray(new String[0])).cleanDisabled(!this.cleanAfter).load();
        this.flyway.migrate();
    }

    @Override
    public void cleanup(DataSource ds, Handle handle) {
        if (this.cleanAfter) {
            this.flyway.clean();
        }
    }
}

