/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.BuiltInArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.array.SqlArrayArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.JdbiStreams;

public class Arguments
implements JdbiConfig<Arguments> {
    private final List<ArgumentFactory> argumentFactories = new CopyOnWriteArrayList<ArgumentFactory>();
    private ConfigRegistry registry;
    private Argument untypedNullArgument = new NullArgument(1111);

    public Arguments() {
        this.register(BuiltInArgumentFactory.INSTANCE);
        this.register(new SqlArrayArgumentFactory());
    }

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    private Arguments(Arguments that) {
        this.argumentFactories.addAll(that.argumentFactories);
        this.untypedNullArgument = that.untypedNullArgument;
    }

    public Arguments register(ArgumentFactory factory) {
        this.argumentFactories.add(0, factory);
        return this;
    }

    public Optional<Argument> findFor(Type type, Object value) {
        return this.argumentFactories.stream().flatMap(factory -> JdbiStreams.toStream(factory.build(type, value, this.registry))).findFirst();
    }

    public void setUntypedNullArgument(Argument untypedNullArgument) {
        if (untypedNullArgument == null) {
            throw new IllegalArgumentException("the Argument itself may not be null");
        }
        this.untypedNullArgument = untypedNullArgument;
    }

    public Argument getUntypedNullArgument() {
        return this.untypedNullArgument;
    }

    @Override
    public Arguments createCopy() {
        return new Arguments(this);
    }
}

