/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.jdbi.v3.core.array.ArrayColumnMapper;
import org.jdbi.v3.core.array.CollectionColumnMapper;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;

public class SqlArrayMapperFactory
implements ColumnMapperFactory {
    private final Map<Class<?>, Supplier<Collection<?>>> suppliers = new HashMap();

    public SqlArrayMapperFactory() {
        this.suppliers.put(List.class, ArrayList::new);
        this.suppliers.put(ArrayList.class, ArrayList::new);
        this.suppliers.put(LinkedList.class, LinkedList::new);
        this.suppliers.put(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new);
        this.suppliers.put(Set.class, HashSet::new);
        this.suppliers.put(HashSet.class, HashSet::new);
        this.suppliers.put(LinkedHashSet.class, LinkedHashSet::new);
        this.suppliers.put(TreeSet.class, TreeSet::new);
    }

    @Override
    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        Class<?> erasedType = GenericTypes.getErasedType(type);
        if (erasedType.isArray()) {
            Class<?> elementType2 = erasedType.getComponentType();
            return this.elementTypeMapper(elementType2, config).map(elementMapper -> new ArrayColumnMapper((ColumnMapper<?>)elementMapper, elementType2));
        }
        Supplier<Collection<?>> supplier = this.suppliers.get(erasedType);
        if (supplier != null) {
            return GenericTypes.findGenericParameter(type, Collection.class).flatMap(elementType -> this.elementTypeMapper((Type)elementType, config)).map(elementMapper -> new CollectionColumnMapper(elementMapper, supplier));
        }
        return Optional.empty();
    }

    private Optional<ColumnMapper<?>> elementTypeMapper(Type elementType, ConfigRegistry config) {
        Optional<ColumnMapper<?>> mapper = config.get(ColumnMappers.class).findFor(elementType);
        if (!mapper.isPresent() && elementType == Object.class) {
            return Optional.of((rs, num, context) -> rs.getObject(num));
        }
        return mapper;
    }
}

