/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.jdbi.v3.core.internal.lexer.HashStatementLexer;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class HashPrefixSqlParser
implements SqlParser {
    private final Map<String, ParsedSql> cache = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public ParsedSql parse(String sql, StatementContext ctx) {
        try {
            return this.cache.computeIfAbsent(sql, this::internalParse);
        }
        catch (IllegalArgumentException e) {
            throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", e, ctx);
        }
    }

    private ParsedSql internalParse(String sql) {
        ParsedSql.Builder parsedSql = ParsedSql.builder();
        HashStatementLexer lexer = new HashStatementLexer((CharStream)new ANTLRStringStream(sql));
        Token t = lexer.nextToken();
        while (t.getType() != -1) {
            switch (t.getType()) {
                case 4: 
                case 6: 
                case 11: 
                case 16: {
                    parsedSql.append(t.getText());
                    break;
                }
                case 13: {
                    parsedSql.appendNamedParameter(t.getText().substring(1));
                    break;
                }
                case 14: {
                    parsedSql.appendPositionalParameter();
                    break;
                }
                case 8: {
                    parsedSql.append(t.getText().substring(1));
                    break;
                }
            }
            t = lexer.nextToken();
        }
        return parsedSql.build();
    }
}

