/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred.android;

import android.os.Handler;
import android.os.Message;
import org.jdeferred.AlwaysCallback;
import org.jdeferred.Deferred;
import org.jdeferred.DoneCallback;
import org.jdeferred.FailCallback;
import org.jdeferred.ProgressCallback;
import org.jdeferred.Promise;
import org.jdeferred.android.AndroidExecutionScope;
import org.jdeferred.android.AndroidExecutionScopeable;
import org.jdeferred.impl.DeferredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidDeferredObject<D, F, P>
extends DeferredObject<D, F, P> {
    private static final InternalHandler sHandler = new InternalHandler();
    private static final int MESSAGE_POST_DONE = 1;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static final int MESSAGE_POST_FAIL = 3;
    private static final int MESSAGE_POST_ALWAYS = 4;
    protected final Logger log = LoggerFactory.getLogger(AndroidDeferredObject.class);
    private final AndroidExecutionScope defaultAndroidExecutionScope;

    public AndroidDeferredObject(Promise<D, F, P> promise) {
        this(promise, AndroidExecutionScope.UI);
    }

    public AndroidDeferredObject(Promise<D, F, P> promise, AndroidExecutionScope defaultAndroidExecutionScope) {
        this.defaultAndroidExecutionScope = defaultAndroidExecutionScope;
        promise.done(new DoneCallback<D>(){

            public void onDone(D result) {
                AndroidDeferredObject.this.resolve(result);
            }
        }).progress(new ProgressCallback<P>(){

            public void onProgress(P progress) {
                AndroidDeferredObject.this.notify(progress);
            }
        }).fail(new FailCallback<F>(){

            public void onFail(F result) {
                AndroidDeferredObject.this.reject(result);
            }
        });
    }

    protected void triggerDone(DoneCallback<D> callback, D resolved) {
        if (this.determineAndroidExecutionScope(callback) == AndroidExecutionScope.UI) {
            this.executeInUiThread(1, callback, Promise.State.RESOLVED, resolved, null, null);
        } else {
            super.triggerDone(callback, resolved);
        }
    }

    protected void triggerFail(FailCallback<F> callback, F rejected) {
        if (this.determineAndroidExecutionScope(callback) == AndroidExecutionScope.UI) {
            this.executeInUiThread(3, callback, Promise.State.REJECTED, null, rejected, null);
        } else {
            super.triggerFail(callback, rejected);
        }
    }

    protected void triggerProgress(ProgressCallback<P> callback, P progress) {
        if (this.determineAndroidExecutionScope(callback) == AndroidExecutionScope.UI) {
            this.executeInUiThread(2, callback, Promise.State.PENDING, null, null, progress);
        } else {
            super.triggerProgress(callback, progress);
        }
    }

    protected void triggerAlways(AlwaysCallback<D, F> callback, Promise.State state, D resolve, F reject) {
        if (this.determineAndroidExecutionScope(callback) == AndroidExecutionScope.UI) {
            this.executeInUiThread(4, callback, state, resolve, reject, null);
        } else {
            super.triggerAlways(callback, state, resolve, reject);
        }
    }

    protected <Callback> void executeInUiThread(int what, Callback callback, Promise.State state, D resolve, F reject, P progress) {
        Message message = sHandler.obtainMessage(what, new CallbackMessage<Callback, D, F, P>((Deferred)this, callback, state, resolve, reject, progress));
        message.sendToTarget();
    }

    protected AndroidExecutionScope determineAndroidExecutionScope(Object callback) {
        AndroidExecutionScope scope = null;
        if (callback instanceof AndroidExecutionScopeable) {
            scope = ((AndroidExecutionScopeable)callback).getExecutionScope();
        }
        return scope == null ? this.defaultAndroidExecutionScope : scope;
    }

    private static class CallbackMessage<Callback, D, F, P> {
        final Deferred deferred;
        final Callback callback;
        final D resolved;
        final F rejected;
        final P progress;
        final Promise.State state;

        CallbackMessage(Deferred deferred, Callback callback, Promise.State state, D resolved, F rejected, P progress) {
            this.deferred = deferred;
            this.callback = callback;
            this.state = state;
            this.resolved = resolved;
            this.rejected = rejected;
            this.progress = progress;
        }
    }

    private static class InternalHandler
    extends Handler {
        private InternalHandler() {
        }

        public void handleMessage(Message msg) {
            CallbackMessage result = (CallbackMessage)msg.obj;
            switch (msg.what) {
                case 1: {
                    ((DoneCallback)result.callback).onDone(result.resolved);
                    break;
                }
                case 2: {
                    ((ProgressCallback)result.callback).onProgress(result.progress);
                    break;
                }
                case 3: {
                    ((FailCallback)result.callback).onFail(result.rejected);
                    break;
                }
                case 4: {
                    ((AlwaysCallback)result.callback).onAlways(result.state, result.resolved, result.rejected);
                }
            }
        }
    }
}

