/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred.android;

import android.os.AsyncTask;
import java.util.concurrent.CancellationException;
import org.jdeferred.DeferredManager;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeferredAsyncTask<Params, Progress, Result>
extends AsyncTask<Params, Progress, Result> {
    protected final Logger log = LoggerFactory.getLogger(DeferredAsyncTask.class);
    private final DeferredObject<Result, Throwable, Progress> deferred = new DeferredObject();
    private final DeferredManager.StartPolicy startPolicy;
    private Throwable throwable;

    public DeferredAsyncTask() {
        this.startPolicy = DeferredManager.StartPolicy.DEFAULT;
    }

    public DeferredAsyncTask(DeferredManager.StartPolicy startPolicy) {
        this.startPolicy = startPolicy;
    }

    protected final void onCancelled() {
        this.deferred.reject((Object)new CancellationException());
    }

    protected final void onCancelled(Result result) {
        this.deferred.reject((Object)new CancellationException());
    }

    protected final void onPostExecute(Result result) {
        if (this.throwable != null) {
            this.deferred.reject((Object)this.throwable);
        } else {
            this.deferred.resolve(result);
        }
    }

    protected final void onProgressUpdate(Progress ... values) {
        if (values == null || values.length == 0) {
            this.deferred.notify(null);
        } else if (values.length == 1) {
            this.deferred.notify(values[0]);
        } else {
            this.log.warn("There were multiple progress values.  Only the first one was used!");
            this.deferred.notify(values[0]);
        }
    }

    protected final Result doInBackground(Params ... params) {
        try {
            return this.doInBackgroundSafe(params);
        }
        catch (Throwable e) {
            this.throwable = e;
            return null;
        }
    }

    protected abstract Result doInBackgroundSafe(Params ... var1) throws Exception;

    protected final void notify(Progress progress) {
        this.publishProgress(new Object[]{progress});
    }

    public Promise<Result, Throwable, Progress> promise() {
        return this.deferred.promise();
    }

    public DeferredManager.StartPolicy getStartPolicy() {
        return this.startPolicy;
    }
}

