/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.hibernate;

import java.time.LocalDateTime;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateRecordReader<T>
implements RecordReader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HibernateRecordReader.class.getSimpleName());
    private SessionFactory sessionFactory;
    private Session session;
    private String query;
    private ScrollableResults scrollableResults;
    private int maxResults;
    private int fetchSize;
    private long currentRecordNumber;

    public HibernateRecordReader(SessionFactory sessionFactory, String query) {
        Utils.checkNotNull((Object)sessionFactory, (String)"session factory");
        Utils.checkNotNull((Object)query, (String)"query");
        this.sessionFactory = sessionFactory;
        this.query = query;
    }

    public void open() {
        LOGGER.debug("Opening a Hibernate session");
        this.session = this.sessionFactory.openSession();
        this.currentRecordNumber = 0L;
        Query hibernateQuery = this.session.createQuery(this.query);
        hibernateQuery.setReadOnly(true);
        if (this.maxResults >= 1) {
            hibernateQuery.setMaxResults(this.maxResults);
        }
        if (this.fetchSize >= 1) {
            hibernateQuery.setFetchSize(this.fetchSize);
        }
        this.scrollableResults = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
    }

    private boolean hasNextRecord() {
        return this.scrollableResults.next();
    }

    public GenericRecord<T> readRecord() {
        if (this.hasNextRecord()) {
            Header header = new Header(Long.valueOf(++this.currentRecordNumber), this.getDataSourceName(), LocalDateTime.now());
            return new GenericRecord(header, this.scrollableResults.get()[0]);
        }
        return null;
    }

    private String getDataSourceName() {
        return "Result of HQL query: " + this.query;
    }

    public void close() {
        if (this.session != null) {
            LOGGER.debug("Closing Hibernate session");
            this.session.close();
        }
    }

    public void setMaxResults(int maxResults) {
        Utils.checkArgument((maxResults >= 1 ? 1 : 0) != 0, (String)"max result parameter must be greater than or equal to 1");
        this.maxResults = maxResults;
    }

    public void setFetchSize(int fetchSize) {
        Utils.checkArgument((fetchSize >= 1 ? 1 : 0) != 0, (String)"fetch size parameter must be greater than or equal to 1");
        this.fetchSize = fetchSize;
    }
}

