/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.core.writer.RecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateRecordWriter<P>
implements RecordWriter<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HibernateRecordWriter.class.getSimpleName());
    private SessionFactory sessionFactory;
    private Session session;

    public HibernateRecordWriter(SessionFactory sessionFactory) {
        Utils.checkNotNull((Object)sessionFactory, (String)"session factory");
        this.sessionFactory = sessionFactory;
    }

    public void open() {
        LOGGER.debug("Opening a Hibernate session");
        this.session = this.sessionFactory.openSession();
    }

    public void writeRecords(Batch<P> batch) {
        Transaction transaction = this.session.getTransaction();
        transaction.begin();
        try {
            for (Record record : batch) {
                this.session.saveOrUpdate(record.getPayload());
            }
            this.session.flush();
            this.session.clear();
            transaction.commit();
            LOGGER.debug("Transaction committed");
        }
        catch (Exception e) {
            LOGGER.error("Unable to commit transaction", (Throwable)e);
            transaction.rollback();
            throw e;
        }
    }

    public void close() {
        try {
            if (this.session != null) {
                LOGGER.debug("Closing Hibernate session");
                this.session.close();
            }
        }
        catch (HibernateException e) {
            LOGGER.error("Unable to close Hibernate session", (Throwable)e);
        }
    }
}

