/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jeasy.batch.core.marshaller.RecordMarshaller;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.json.JsonRecord;

public class JacksonRecordMarshaller<P>
implements RecordMarshaller<Record<P>, JsonRecord> {
    private ObjectMapper mapper;

    public JacksonRecordMarshaller() {
        this.mapper = new ObjectMapper();
    }

    public JacksonRecordMarshaller(ObjectMapper mapper) {
        Utils.checkNotNull((Object)mapper, (String)"object mapper");
        this.mapper = mapper;
    }

    public JsonRecord processRecord(Record<P> record) throws Exception {
        return new JsonRecord(record.getHeader(), this.mapper.writeValueAsString(record.getPayload()));
    }
}

