/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;

public class JacksonRecordMapper<T>
implements RecordMapper<String, T> {
    private ObjectMapper mapper;
    private Class<T> type;

    public JacksonRecordMapper(Class<T> type) {
        this.type = type;
        this.mapper = new ObjectMapper();
    }

    public JacksonRecordMapper(ObjectMapper mapper, Class<T> type) {
        Utils.checkNotNull((Object)mapper, (String)"object mapper");
        Utils.checkNotNull(type, (String)"target type");
        this.mapper = mapper;
        this.type = type;
    }

    public Record<T> processRecord(Record<String> record) throws Exception {
        return new GenericRecord(record.getHeader(), this.mapper.readValue(((String)record.getPayload()).getBytes(), this.type));
    }
}

