/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.json;

import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.jeasy.batch.core.marshaller.RecordMarshaller;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.json.JsonRecord;

public class JsonRecordMarshaller<P>
implements RecordMarshaller<Record<P>, JsonRecord> {
    private Jsonb jsonb;

    public JsonRecordMarshaller() {
        this.jsonb = JsonbBuilder.create();
    }

    public JsonRecordMarshaller(Jsonb jsonb) {
        Utils.checkNotNull((Object)jsonb, (String)"jsonb parameter");
        this.jsonb = jsonb;
    }

    public JsonRecord processRecord(Record<P> record) {
        String payload = this.jsonb.toJson(record.getPayload());
        return new JsonRecord(record.getHeader(), payload);
    }
}

