/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.json;

import java.io.ByteArrayInputStream;
import org.jeasy.batch.core.processor.RecordCompactor;
import org.jeasy.batch.json.JsonRecord;
import org.jeasy.batch.json.JsonRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRecordCompactor
extends RecordCompactor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JsonRecordCompactor.class.getName());

    protected String compact(String payload) {
        if (payload == null) {
            return null;
        }
        if (payload.trim().isEmpty()) {
            return "";
        }
        String dataSource = "[" + payload + "]";
        return this.doCompactPayload(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doCompactPayload(String dataSource) {
        String flatJson = "";
        JsonRecordReader jsonRecordReader = null;
        try {
            jsonRecordReader = new JsonRecordReader(new ByteArrayInputStream(dataSource.getBytes()));
            jsonRecordReader.open();
            JsonRecord jsonRecord = jsonRecordReader.readRecord();
            if (jsonRecord != null) {
                flatJson = (String)jsonRecord.getPayload();
            }
            String string = flatJson;
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Unable to compact record payload", (Throwable)exception);
            String string = "";
            return string;
        }
        finally {
            if (jsonRecordReader != null) {
                try {
                    jsonRecordReader.close();
                }
                catch (Exception e) {
                    LOGGER.error("Unable to close json reader", (Throwable)e);
                }
            }
        }
    }
}

