/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.json;

import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;

public class JsonRecordMapper<P>
implements RecordMapper<String, P> {
    private Jsonb jsonb;
    private Class<P> type;

    public JsonRecordMapper(Class<P> type) {
        this.type = type;
        this.jsonb = JsonbBuilder.create();
    }

    public JsonRecordMapper(Jsonb jsonb, Class<P> type) {
        Utils.checkNotNull((Object)jsonb, (String)"Jsonb object mapper");
        Utils.checkNotNull(type, (String)"target type");
        this.jsonb = jsonb;
        this.type = type;
    }

    public Record<P> processRecord(Record<String> record) {
        Object mappedObject = this.jsonb.fromJson((String)record.getPayload(), this.type);
        return new GenericRecord(record.getHeader(), mappedObject);
    }
}

