/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.json;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.jeasy.batch.core.reader.AbstractFileRecordReader;
import org.jeasy.batch.json.JsonRecord;
import org.jeasy.batch.json.JsonRecordReader;

public class JsonFileRecordReader
extends AbstractFileRecordReader<String> {
    private JsonRecordReader jsonRecordReader;

    public JsonFileRecordReader(Path jsonFile) {
        this(jsonFile, Charset.defaultCharset());
    }

    public JsonFileRecordReader(Path jsonFile, Charset charset) {
        super(jsonFile, charset);
    }

    public void open() throws Exception {
        this.jsonRecordReader = new Reader(this.path, this.charset);
        this.jsonRecordReader.open();
    }

    public JsonRecord readRecord() {
        return this.jsonRecordReader.readRecord();
    }

    public void close() throws Exception {
        this.jsonRecordReader.close();
    }

    private static class Reader
    extends JsonRecordReader {
        private Path path;

        Reader(Path path, Charset charset) throws FileNotFoundException {
            super(new FileInputStream(path.toFile()), charset);
            this.path = path;
        }

        @Override
        protected String getDataSourceName() {
            return this.path.toAbsolutePath().toString();
        }
    }
}

