/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.json;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.json.JsonRecord;

public class JsonRecordReader
implements RecordReader<String> {
    private InputStream inputStream;
    private JsonParser parser;
    private JsonGeneratorFactory jsonGeneratorFactory;
    private Charset charset;
    private long currentRecordNumber;
    private JsonParser.Event currentEvent;
    private JsonParser.Event nextEvent;
    private int arrayDepth;
    private int objectDepth;
    private String key;

    public JsonRecordReader(InputStream inputStream) {
        this(inputStream, Charset.defaultCharset());
    }

    public JsonRecordReader(InputStream inputStream, Charset charset) {
        Utils.checkNotNull((Object)inputStream, (String)"input stream");
        Utils.checkNotNull((Object)charset, (String)"charset");
        this.inputStream = inputStream;
        this.charset = charset;
        this.jsonGeneratorFactory = Json.createGeneratorFactory(new HashMap());
    }

    public void open() {
        this.parser = Json.createParser((Reader)new InputStreamReader(this.inputStream, this.charset));
    }

    private boolean hasNextRecord() {
        if (this.parser.hasNext()) {
            this.currentEvent = this.parser.next();
            if (JsonParser.Event.START_ARRAY.equals((Object)this.currentEvent)) {
                ++this.arrayDepth;
            }
            if (JsonParser.Event.END_ARRAY.equals((Object)this.currentEvent)) {
                --this.arrayDepth;
            }
            if (JsonParser.Event.KEY_NAME.equals((Object)this.currentEvent)) {
                this.key = this.parser.getString();
            }
        }
        if (this.parser.hasNext()) {
            this.nextEvent = this.parser.next();
            if (JsonParser.Event.START_ARRAY.equals((Object)this.nextEvent)) {
                ++this.arrayDepth;
            }
            if (JsonParser.Event.END_ARRAY.equals((Object)this.nextEvent)) {
                --this.arrayDepth;
            }
            if (JsonParser.Event.KEY_NAME.equals((Object)this.nextEvent)) {
                this.key = this.parser.getString();
            }
        }
        if (JsonParser.Event.START_ARRAY.equals((Object)this.currentEvent) && JsonParser.Event.END_ARRAY.equals((Object)this.nextEvent) && this.arrayDepth == 0) {
            return false;
        }
        return !JsonParser.Event.END_ARRAY.equals((Object)this.currentEvent) || this.arrayDepth != 1 || this.objectDepth != 0;
    }

    public JsonRecord readRecord() {
        if (this.hasNextRecord()) {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator jsonGenerator = this.jsonGeneratorFactory.createGenerator((Writer)stringWriter);
            this.writeRecordStart(jsonGenerator);
            do {
                this.moveToNextElement(jsonGenerator);
            } while (!this.isEndRootObject());
            if (this.arrayDepth != 2) {
                jsonGenerator.writeEnd();
            }
            jsonGenerator.close();
            Header header = new Header(Long.valueOf(++this.currentRecordNumber), this.getDataSourceName(), LocalDateTime.now());
            return new JsonRecord(header, stringWriter.toString());
        }
        return null;
    }

    protected String getDataSourceName() {
        return "Json stream";
    }

    public void close() throws Exception {
        this.parser.close();
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    private boolean isEndRootObject() {
        return this.objectDepth == 0;
    }

    private void writeRecordStart(JsonGenerator jsonGenerator) {
        if (this.currentEvent.equals((Object)JsonParser.Event.START_ARRAY)) {
            if (this.arrayDepth != 1) {
                jsonGenerator.writeStartArray();
            }
            ++this.arrayDepth;
        }
        if (this.currentEvent.equals((Object)JsonParser.Event.START_OBJECT)) {
            jsonGenerator.writeStartObject();
            ++this.objectDepth;
        }
        if (this.nextEvent.equals((Object)JsonParser.Event.START_ARRAY)) {
            jsonGenerator.writeStartArray();
            ++this.arrayDepth;
        }
        if (this.nextEvent.equals((Object)JsonParser.Event.START_OBJECT)) {
            jsonGenerator.writeStartObject();
            ++this.objectDepth;
        }
    }

    private void moveToNextElement(JsonGenerator jsonGenerator) {
        JsonParser.Event event = this.parser.next();
        switch (event) {
            case START_ARRAY: {
                try {
                    jsonGenerator.writeStartArray();
                }
                catch (JsonGenerationException e) {
                    jsonGenerator.writeStartArray(this.key);
                }
                break;
            }
            case END_ARRAY: {
                jsonGenerator.writeEnd();
                break;
            }
            case START_OBJECT: {
                ++this.objectDepth;
                try {
                    jsonGenerator.writeStartObject();
                }
                catch (Exception e) {
                    jsonGenerator.writeStartObject(this.key);
                }
                break;
            }
            case END_OBJECT: {
                --this.objectDepth;
                jsonGenerator.writeEnd();
                break;
            }
            case VALUE_FALSE: {
                try {
                    jsonGenerator.write(JsonValue.FALSE);
                }
                catch (Exception e) {
                    jsonGenerator.write(this.key, JsonValue.FALSE);
                }
                break;
            }
            case VALUE_NULL: {
                try {
                    jsonGenerator.write(JsonValue.NULL);
                }
                catch (Exception e) {
                    jsonGenerator.write(this.key, JsonValue.NULL);
                }
                break;
            }
            case VALUE_TRUE: {
                try {
                    jsonGenerator.write(JsonValue.TRUE);
                }
                catch (Exception e) {
                    jsonGenerator.write(this.key, JsonValue.TRUE);
                }
                break;
            }
            case KEY_NAME: {
                this.key = this.parser.getString();
                break;
            }
            case VALUE_STRING: {
                try {
                    jsonGenerator.write(this.parser.getString());
                }
                catch (Exception e) {
                    jsonGenerator.write(this.key, this.parser.getString());
                }
                break;
            }
            case VALUE_NUMBER: {
                try {
                    jsonGenerator.write(this.parser.getBigDecimal());
                }
                catch (Exception e) {
                    jsonGenerator.write(this.key, this.parser.getBigDecimal());
                }
                break;
            }
        }
    }
}

