/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.engine;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jeasy.flows.engine.WorkFlowEngine;
import org.jeasy.flows.engine.WorkFlowEngineImpl;

public class WorkFlowEngineBuilder {
    private static final Logger LOGGER = Logger.getLogger(WorkFlowEngineBuilder.class.getName());

    public static WorkFlowEngineBuilder aNewWorkFlowEngine() {
        return new WorkFlowEngineBuilder();
    }

    private WorkFlowEngineBuilder() {
    }

    public WorkFlowEngine build() {
        return new WorkFlowEngineImpl();
    }

    static {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(WorkFlowEngineBuilder.class.getResourceAsStream("/logging.properties"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load log configuration file", e);
        }
    }
}

