/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.workflow;

import java.util.UUID;
import org.jeasy.flows.work.NoOpWork;
import org.jeasy.flows.work.Work;
import org.jeasy.flows.work.WorkContext;
import org.jeasy.flows.work.WorkReport;
import org.jeasy.flows.work.WorkReportPredicate;
import org.jeasy.flows.workflow.AbstractWorkFlow;

public class ConditionalFlow
extends AbstractWorkFlow {
    private Work toExecute;
    private Work nextOnPredicateSuccess;
    private Work nextOnPredicateFailure;
    private WorkReportPredicate predicate;

    ConditionalFlow(String name, Work toExecute, Work nextOnPredicateSuccess, Work nextOnPredicateFailure, WorkReportPredicate predicate) {
        super(name);
        this.toExecute = toExecute;
        this.nextOnPredicateSuccess = nextOnPredicateSuccess;
        this.nextOnPredicateFailure = nextOnPredicateFailure;
        this.predicate = predicate;
    }

    @Override
    public WorkReport call(WorkContext workContext) {
        WorkReport jobReport = this.toExecute.call(workContext);
        if (this.predicate.apply(jobReport)) {
            jobReport = this.nextOnPredicateSuccess.call(workContext);
        } else if (this.nextOnPredicateFailure != null && !(this.nextOnPredicateFailure instanceof NoOpWork)) {
            jobReport = this.nextOnPredicateFailure.call(workContext);
        }
        return jobReport;
    }

    public static class Builder {
        private String name = UUID.randomUUID().toString();
        private Work toExecute = new NoOpWork();
        private Work nextOnPredicateSuccess = new NoOpWork();
        private Work nextOnPredicateFailure = new NoOpWork();
        private WorkReportPredicate predicate = WorkReportPredicate.ALWAYS_FALSE;

        private Builder() {
        }

        public static Builder aNewConditionalFlow() {
            return new Builder();
        }

        public Builder named(String name) {
            this.name = name;
            return this;
        }

        public Builder execute(Work work) {
            this.toExecute = work;
            return this;
        }

        public Builder when(WorkReportPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder then(Work work) {
            this.nextOnPredicateSuccess = work;
            return this;
        }

        public Builder otherwise(Work work) {
            this.nextOnPredicateFailure = work;
            return this;
        }

        public ConditionalFlow build() {
            return new ConditionalFlow(this.name, this.toExecute, this.nextOnPredicateSuccess, this.nextOnPredicateFailure, this.predicate);
        }
    }
}

