/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jeasy.flows.work.Work;
import org.jeasy.flows.work.WorkContext;
import org.jeasy.flows.work.WorkReport;
import org.jeasy.flows.workflow.AbstractWorkFlow;
import org.jeasy.flows.workflow.ParallelFlowExecutor;
import org.jeasy.flows.workflow.ParallelFlowReport;

public class ParallelFlow
extends AbstractWorkFlow {
    private List<Work> works = new ArrayList<Work>();
    private ParallelFlowExecutor workExecutor;

    ParallelFlow(String name, List<Work> works, ParallelFlowExecutor parallelFlowExecutor) {
        super(name);
        this.works.addAll(works);
        this.workExecutor = parallelFlowExecutor;
    }

    @Override
    public ParallelFlowReport call(WorkContext workContext) {
        ParallelFlowReport workFlowReport = new ParallelFlowReport();
        List<WorkReport> workReports = this.workExecutor.executeInParallel(this.works, workContext);
        workFlowReport.addAll(workReports);
        return workFlowReport;
    }

    public static class Builder {
        private String name = UUID.randomUUID().toString();
        private List<Work> works = new ArrayList<Work>();
        private ExecutorService executorService;

        private Builder(ExecutorService executorService) {
            this.executorService = executorService;
        }

        public static Builder aNewParallelFlow(ExecutorService executorService) {
            return new Builder(executorService);
        }

        public Builder named(String name) {
            this.name = name;
            return this;
        }

        public Builder execute(Work ... works) {
            this.works.addAll(Arrays.asList(works));
            return this;
        }

        public ParallelFlow build() {
            return new ParallelFlow(this.name, this.works, new ParallelFlowExecutor(this.executorService));
        }
    }
}

