/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.flows.work.Work;
import org.jeasy.flows.work.WorkContext;
import org.jeasy.flows.work.WorkReport;

class ParallelFlowExecutor {
    private static final Logger LOGGER = Logger.getLogger(ParallelFlowExecutor.class.getName());
    private ExecutorService workExecutor;

    ParallelFlowExecutor(ExecutorService workExecutor) {
        this.workExecutor = workExecutor;
    }

    List<WorkReport> executeInParallel(List<Work> works, WorkContext workContext) {
        HashMap<Work, Future<WorkReport>> reportFutures = new HashMap<Work, Future<WorkReport>>();
        for (Work work : works) {
            Future<WorkReport> reportFuture = this.workExecutor.submit(() -> work.call(workContext));
            reportFutures.put(work, reportFuture);
        }
        int finishedWorks = works.size();
        while (finishedWorks > 0) {
            for (Future future : reportFutures.values()) {
                if (future == null || !future.isDone()) continue;
                --finishedWorks;
            }
        }
        ArrayList<WorkReport> arrayList = new ArrayList<WorkReport>();
        for (Map.Entry entry : reportFutures.entrySet()) {
            try {
                arrayList.add((WorkReport)((Future)entry.getValue()).get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.log(Level.WARNING, "Unable to get report of work unit ''{0}''", ((Work)entry.getKey()).getName());
            }
        }
        return arrayList;
    }
}

