/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.workflow;

import java.util.UUID;
import org.jeasy.flows.work.NoOpWork;
import org.jeasy.flows.work.Work;
import org.jeasy.flows.work.WorkContext;
import org.jeasy.flows.work.WorkReport;
import org.jeasy.flows.work.WorkReportPredicate;
import org.jeasy.flows.workflow.AbstractWorkFlow;

public class RepeatFlow
extends AbstractWorkFlow {
    private Work work;
    private WorkReportPredicate predicate;

    RepeatFlow(String name, Work work, WorkReportPredicate predicate) {
        super(name);
        this.work = work;
        this.predicate = predicate;
    }

    @Override
    public WorkReport call(WorkContext workContext) {
        WorkReport workReport;
        while (this.predicate.apply(workReport = this.work.call(workContext))) {
        }
        return workReport;
    }

    public static class Builder {
        private String name = UUID.randomUUID().toString();
        private Work work = new NoOpWork();
        private WorkReportPredicate predicate = WorkReportPredicate.ALWAYS_FALSE;

        private Builder() {
        }

        public static Builder aNewRepeatFlow() {
            return new Builder();
        }

        public Builder named(String name) {
            this.name = name;
            return this;
        }

        public Builder repeat(Work work) {
            this.work = work;
            return this;
        }

        public Builder times(int times) {
            return this.until(WorkReportPredicate.TimesPredicate.times(times));
        }

        public Builder until(WorkReportPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public RepeatFlow build() {
            return new RepeatFlow(this.name, this.work, this.predicate);
        }
    }
}

