/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.flows.work.Work;
import org.jeasy.flows.work.WorkContext;
import org.jeasy.flows.work.WorkReport;
import org.jeasy.flows.work.WorkStatus;
import org.jeasy.flows.workflow.AbstractWorkFlow;

public class SequentialFlow
extends AbstractWorkFlow {
    private static final Logger LOGGER = Logger.getLogger(SequentialFlow.class.getName());
    private List<Work> works = new ArrayList<Work>();

    SequentialFlow(String name, List<Work> works) {
        super(name);
        this.works.addAll(works);
    }

    @Override
    public WorkReport call(WorkContext workContext) {
        WorkReport workReport = null;
        for (Work work : this.works) {
            workReport = work.call(workContext);
            if (workReport == null || !WorkStatus.FAILED.equals((Object)workReport.getStatus())) continue;
            LOGGER.log(Level.INFO, "Work unit ''{0}'' has failed, skipping subsequent work units", work.getName());
            break;
        }
        return workReport;
    }

    public static class Builder {
        private String name = UUID.randomUUID().toString();
        private List<Work> works = new ArrayList<Work>();

        private Builder() {
        }

        public static Builder aNewSequentialFlow() {
            return new Builder();
        }

        public Builder named(String name) {
            this.name = name;
            return this;
        }

        public Builder execute(Work work) {
            this.works.add(work);
            return this;
        }

        public Builder then(Work work) {
            this.works.add(work);
            return this;
        }

        public SequentialFlow build() {
            return new SequentialFlow(this.name, this.works);
        }
    }
}

