/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;

class FutureAnnotationHandler
implements BeanValidationAnnotationHandler {
    private final long seed;
    private EasyRandom easyRandom;

    FutureAnnotationHandler(long seed) {
        this.seed = seed;
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        if (this.easyRandom == null) {
            LocalDate now = LocalDate.now();
            EasyRandomParameters parameters = new EasyRandomParameters().seed(this.seed).dateRange(now.plus(1L, ChronoUnit.DAYS), now.plusYears(10L));
            this.easyRandom = new EasyRandom(parameters);
        }
        return () -> this.easyRandom.nextObject(field.getType());
    }
}

