/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Email;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.annotation.Priority;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerRegistry;
import org.jeasy.random.util.ReflectionUtils;
import org.jeasy.random.validation.AssertFalseAnnotationHandler;
import org.jeasy.random.validation.AssertTrueAnnotationHandler;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;
import org.jeasy.random.validation.DecimalMinMaxAnnotationHandler;
import org.jeasy.random.validation.EmailAnnotationHandler;
import org.jeasy.random.validation.FutureAnnotationHandler;
import org.jeasy.random.validation.FutureOrPresentAnnotationHandler;
import org.jeasy.random.validation.MinMaxAnnotationHandler;
import org.jeasy.random.validation.NegativeAnnotationHandler;
import org.jeasy.random.validation.NegativeOrZeroAnnotationHandler;
import org.jeasy.random.validation.NotBlankAnnotationHandler;
import org.jeasy.random.validation.NullAnnotationHandler;
import org.jeasy.random.validation.PastAnnotationHandler;
import org.jeasy.random.validation.PastOrPresentAnnotationHandler;
import org.jeasy.random.validation.PatternAnnotationHandler;
import org.jeasy.random.validation.PositiveAnnotationHandler;
import org.jeasy.random.validation.PositiveOrZeroAnnotationHandler;
import org.jeasy.random.validation.SizeAnnotationHandler;

@Priority(value=-2)
public class BeanValidationRandomizerRegistry
implements RandomizerRegistry {
    private Map<Class<? extends Annotation>, BeanValidationAnnotationHandler> annotationHandlers = new HashMap<Class<? extends Annotation>, BeanValidationAnnotationHandler>();

    public void init(EasyRandomParameters parameters) {
        long seed = parameters.getSeed();
        Charset charset = parameters.getCharset();
        this.annotationHandlers.put(AssertFalse.class, new AssertFalseAnnotationHandler());
        this.annotationHandlers.put(AssertTrue.class, new AssertTrueAnnotationHandler());
        this.annotationHandlers.put(Null.class, new NullAnnotationHandler());
        this.annotationHandlers.put(Future.class, new FutureAnnotationHandler(seed));
        this.annotationHandlers.put(FutureOrPresent.class, new FutureOrPresentAnnotationHandler(seed));
        this.annotationHandlers.put(Past.class, new PastAnnotationHandler(seed));
        this.annotationHandlers.put(PastOrPresent.class, new PastOrPresentAnnotationHandler(seed));
        this.annotationHandlers.put(Min.class, new MinMaxAnnotationHandler(seed));
        this.annotationHandlers.put(Max.class, new MinMaxAnnotationHandler(seed));
        this.annotationHandlers.put(DecimalMin.class, new DecimalMinMaxAnnotationHandler(seed));
        this.annotationHandlers.put(DecimalMax.class, new DecimalMinMaxAnnotationHandler(seed));
        this.annotationHandlers.put(Pattern.class, new PatternAnnotationHandler(seed));
        this.annotationHandlers.put(Size.class, new SizeAnnotationHandler(seed, charset));
        this.annotationHandlers.put(Positive.class, new PositiveAnnotationHandler(seed));
        this.annotationHandlers.put(PositiveOrZero.class, new PositiveOrZeroAnnotationHandler(seed));
        this.annotationHandlers.put(Negative.class, new NegativeAnnotationHandler(seed));
        this.annotationHandlers.put(NegativeOrZero.class, new NegativeOrZeroAnnotationHandler(seed));
        this.annotationHandlers.put(NotBlank.class, new NotBlankAnnotationHandler(seed));
        this.annotationHandlers.put(Email.class, new EmailAnnotationHandler(seed));
    }

    public Randomizer<?> getRandomizer(Field field) {
        for (Map.Entry<Class<? extends Annotation>, BeanValidationAnnotationHandler> entry : this.annotationHandlers.entrySet()) {
            Class<? extends Annotation> annotation = entry.getKey();
            BeanValidationAnnotationHandler annotationHandler = entry.getValue();
            if (!ReflectionUtils.isAnnotationPresent((Field)field, annotation) || annotationHandler == null) continue;
            return annotationHandler.getRandomizer(field);
        }
        return null;
    }

    public Randomizer<?> getRandomizer(Class<?> fieldType) {
        return null;
    }
}

