/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.range.BigDecimalRangeRandomizer;
import org.jeasy.random.randomizers.range.BigIntegerRangeRandomizer;
import org.jeasy.random.randomizers.range.ByteRangeRandomizer;
import org.jeasy.random.randomizers.range.IntegerRangeRandomizer;
import org.jeasy.random.randomizers.range.LongRangeRandomizer;
import org.jeasy.random.randomizers.range.ShortRangeRandomizer;
import org.jeasy.random.util.ReflectionUtils;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;

class MinMaxAnnotationHandler
implements BeanValidationAnnotationHandler {
    private final Random random;

    MinMaxAnnotationHandler(long seed) {
        this.random = new Random(seed);
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        Class<?> fieldType = field.getType();
        Max maxAnnotation = (Max)ReflectionUtils.getAnnotation((Field)field, Max.class);
        Min minAnnotation = (Min)ReflectionUtils.getAnnotation((Field)field, Min.class);
        Long maxValue = null;
        Long minValue = null;
        if (maxAnnotation != null) {
            maxValue = maxAnnotation.value();
        }
        if (minAnnotation != null) {
            minValue = minAnnotation.value();
        }
        if (fieldType.equals(Byte.TYPE) || fieldType.equals(Byte.class)) {
            return new ByteRangeRandomizer(minValue == null ? null : Byte.valueOf(minValue.byteValue()), maxValue == null ? null : Byte.valueOf(maxValue.byteValue()), this.random.nextLong());
        }
        if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
            return new ShortRangeRandomizer(minValue == null ? null : Short.valueOf(minValue.shortValue()), maxValue == null ? null : Short.valueOf(maxValue.shortValue()), this.random.nextLong());
        }
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            return new IntegerRangeRandomizer(minValue == null ? null : Integer.valueOf(minValue.intValue()), maxValue == null ? null : Integer.valueOf(maxValue.intValue()), this.random.nextLong());
        }
        if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            return new LongRangeRandomizer(minValue == null ? null : minValue, maxValue == null ? null : maxValue, this.random.nextLong());
        }
        if (fieldType.equals(BigInteger.class)) {
            return new BigIntegerRangeRandomizer(minValue == null ? null : Integer.valueOf(minValue.intValue()), maxValue == null ? null : Integer.valueOf(maxValue.intValue()), this.random.nextLong());
        }
        if (fieldType.equals(BigDecimal.class)) {
            return new BigDecimalRangeRandomizer(minValue == null ? null : Double.valueOf(minValue.doubleValue()), maxValue == null ? null : Double.valueOf(maxValue.doubleValue()), this.random.nextLong());
        }
        return null;
    }
}

