/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.reflect.Field;
import java.time.LocalDate;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;

class PastOrPresentAnnotationHandler
implements BeanValidationAnnotationHandler {
    private final long seed;
    private EasyRandom easyRandom;

    PastOrPresentAnnotationHandler(long seed) {
        this.seed = seed;
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        if (this.easyRandom == null) {
            LocalDate now = LocalDate.now();
            EasyRandomParameters parameters = new EasyRandomParameters().seed(this.seed).dateRange(now.minusYears(10L), now);
            this.easyRandom = new EasyRandom(parameters);
        }
        return () -> this.easyRandom.nextObject(field.getType());
    }
}

