/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.validation.constraints.Size;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.range.IntegerRangeRandomizer;
import org.jeasy.random.randomizers.text.StringRandomizer;
import org.jeasy.random.util.ReflectionUtils;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;
import org.objenesis.ObjenesisStd;

class SizeAnnotationHandler
implements BeanValidationAnnotationHandler {
    private EasyRandom easyRandom;
    private EasyRandomParameters parameters;

    SizeAnnotationHandler(EasyRandomParameters parameters) {
        this.parameters = parameters.copy();
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        int max;
        Class<?> fieldType = field.getType();
        Size sizeAnnotation = (Size)ReflectionUtils.getAnnotation((Field)field, Size.class);
        int min = sizeAnnotation.min();
        int n = max = sizeAnnotation.max() == Integer.MAX_VALUE ? 255 : sizeAnnotation.max();
        if (this.easyRandom == null) {
            this.parameters.setCollectionSizeRange(new EasyRandomParameters.Range((Object)min, (Object)max));
            this.parameters.setStringLengthRange(new EasyRandomParameters.Range((Object)min, (Object)max));
            this.easyRandom = new EasyRandom(this.parameters);
        }
        if (fieldType.equals(String.class)) {
            return new StringRandomizer(this.parameters.getCharset(), min, max, this.easyRandom.nextLong());
        }
        if (ReflectionUtils.isArrayType(fieldType)) {
            return () -> {
                int randomSize = new IntegerRangeRandomizer(Integer.valueOf(min), Integer.valueOf(max), this.parameters.getSeed()).getRandomValue();
                Object result = Array.newInstance(field.getType().getComponentType(), randomSize);
                for (int i = 0; i < randomSize; ++i) {
                    Object randomElement = this.easyRandom.nextObject(fieldType.getComponentType());
                    Array.set(result, i, randomElement);
                }
                return result;
            };
        }
        if (ReflectionUtils.isCollectionType(fieldType)) {
            return () -> {
                ParameterizedType parameterizedType;
                Type type;
                int randomSize = new IntegerRangeRandomizer(Integer.valueOf(min), Integer.valueOf(max), this.parameters.getSeed()).getRandomValue();
                Type fieldGenericType = field.getGenericType();
                Collection collection = ReflectionUtils.isInterface((Class)fieldType) ? ReflectionUtils.getEmptyImplementationForCollectionInterface((Class)fieldType) : ReflectionUtils.createEmptyCollectionForType((Class)fieldType, (int)randomSize);
                if (ReflectionUtils.isParameterizedType((Type)fieldGenericType) && ReflectionUtils.isPopulatable((Type)(type = (parameterizedType = (ParameterizedType)fieldGenericType).getActualTypeArguments()[0]))) {
                    for (int i = 0; i < randomSize; ++i) {
                        Object item = this.easyRandom.nextObject((Class)type);
                        collection.add(item);
                    }
                }
                return collection;
            };
        }
        if (ReflectionUtils.isMapType(fieldType)) {
            return () -> {
                EnumMap<Object, Object> map;
                int randomSize = new IntegerRangeRandomizer(Integer.valueOf(min), Integer.valueOf(max), this.parameters.getSeed()).getRandomValue();
                Type fieldGenericType = field.getGenericType();
                if (ReflectionUtils.isInterface((Class)fieldType)) {
                    map = ReflectionUtils.getEmptyImplementationForMapInterface((Class)fieldType);
                } else {
                    try {
                        map = (Map)fieldType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        if (fieldType.isAssignableFrom(EnumMap.class)) {
                            if (ReflectionUtils.isParameterizedType((Type)fieldGenericType)) {
                                Type type = ((ParameterizedType)fieldGenericType).getActualTypeArguments()[0];
                                map = new EnumMap<Object, Object>((Class)type);
                            }
                            return null;
                        }
                        map = (Map)new ObjenesisStd().newInstance(fieldType);
                    }
                }
                if (ReflectionUtils.isParameterizedType((Type)fieldGenericType)) {
                    ParameterizedType parameterizedType = (ParameterizedType)fieldGenericType;
                    Type keyType = parameterizedType.getActualTypeArguments()[0];
                    Type valueType = parameterizedType.getActualTypeArguments()[1];
                    if (ReflectionUtils.isPopulatable((Type)keyType) && ReflectionUtils.isPopulatable((Type)valueType)) {
                        for (int index = 0; index < randomSize; ++index) {
                            Object randomKey = this.easyRandom.nextObject((Class)keyType);
                            Object randomValue = this.easyRandom.nextObject((Class)valueType);
                            if (randomKey == null) continue;
                            map.put(randomKey, randomValue);
                        }
                    }
                }
                return map;
            };
        }
        return null;
    }
}

