/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.jexl;

import java.io.Reader;
import java.util.List;
import java.util.Objects;
import org.apache.commons.jexl3.JexlEngine;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.jexl.JexlRule;
import org.jeasy.rules.support.AbstractRuleFactory;
import org.jeasy.rules.support.RuleDefinition;
import org.jeasy.rules.support.reader.RuleDefinitionReader;

public class JexlRuleFactory
extends AbstractRuleFactory {
    private final RuleDefinitionReader reader;
    private final JexlEngine jexl;

    public JexlRuleFactory(RuleDefinitionReader reader) {
        this(reader, JexlRule.DEFAULT_JEXL);
    }

    public JexlRuleFactory(RuleDefinitionReader reader, JexlEngine jexl) {
        this.reader = Objects.requireNonNull(reader, "reader cannot be null");
        this.jexl = Objects.requireNonNull(jexl, "Jexl Engine cannot be null");
    }

    public Rule createRule(Reader ruleDescriptor) throws Exception {
        Objects.requireNonNull(ruleDescriptor, "ruleDescriptor cannot be null");
        Objects.requireNonNull(this.jexl, "jexl cannot be null");
        List ruleDefinitions = this.reader.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return this.createRule((RuleDefinition)ruleDefinitions.get(0));
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        Objects.requireNonNull(rulesDescriptor, "rulesDescriptor cannot be null");
        Rules rules = new Rules(new Rule[0]);
        List ruleDefinitions = this.reader.read(rulesDescriptor);
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            rules.register(new Object[]{this.createRule(ruleDefinition)});
        }
        return rules;
    }

    protected Rule createSimpleRule(RuleDefinition ruleDefinition) {
        Objects.requireNonNull(ruleDefinition, "ruleDefinition cannot be null");
        JexlRule rule = new JexlRule(this.jexl).name(ruleDefinition.getName()).description(ruleDefinition.getDescription()).priority(ruleDefinition.getPriority()).when(ruleDefinition.getCondition());
        for (String action : ruleDefinition.getActions()) {
            rule.then(action);
        }
        return rule;
    }
}

