/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.mvel;

import java.io.Reader;
import java.util.List;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.mvel.MVELRule;
import org.jeasy.rules.support.AbstractRuleFactory;
import org.jeasy.rules.support.RuleDefinition;
import org.jeasy.rules.support.RuleDefinitionReader;
import org.mvel2.ParserContext;

public class MVELRuleFactory
extends AbstractRuleFactory<ParserContext> {
    private RuleDefinitionReader reader;

    public MVELRuleFactory(RuleDefinitionReader reader) {
        this.reader = reader;
    }

    public Rule createRule(Reader ruleDescriptor) throws Exception {
        return this.createRule(ruleDescriptor, new ParserContext());
    }

    public Rule createRule(Reader ruleDescriptor, ParserContext parserContext) throws Exception {
        List ruleDefinitions = this.reader.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return this.createRule((RuleDefinition)ruleDefinitions.get(0), parserContext);
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        return this.createRules(rulesDescriptor, new ParserContext());
    }

    public Rules createRules(Reader rulesDescriptor, ParserContext parserContext) throws Exception {
        Rules rules = new Rules(new Rule[0]);
        List ruleDefinitions = this.reader.read(rulesDescriptor);
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            rules.register((Object)this.createRule(ruleDefinition, parserContext));
        }
        return rules;
    }

    protected Rule createSimpleRule(RuleDefinition ruleDefinition, ParserContext parserContext) {
        MVELRule mvelRule = new MVELRule().name(ruleDefinition.getName()).description(ruleDefinition.getDescription()).priority(ruleDefinition.getPriority()).when(ruleDefinition.getCondition(), parserContext);
        for (String action : ruleDefinition.getActions()) {
            mvelRule.then(action, parserContext);
        }
        return mvelRule;
    }
}

