/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.spel;

import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Facts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpELCondition
implements Condition {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpELCondition.class);
    private final ExpressionParser parser = new SpelExpressionParser();
    private String expression;
    private Expression compiledExpression;

    public SpELCondition(String expression) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression);
    }

    public SpELCondition(String expression, ParserContext parserContext) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression, parserContext);
    }

    public boolean evaluate(Facts facts) {
        try {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject((Object)facts.asMap());
            context.setVariables(facts.asMap());
            return (Boolean)this.compiledExpression.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            LOGGER.error("Unable to evaluate expression: '" + this.expression + "' on facts: " + facts, (Throwable)e);
            return false;
        }
    }
}

