/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.support;

import java.util.Arrays;
import java.util.List;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.support.ActivationRuleGroup;
import org.jeasy.rules.support.CompositeRule;
import org.jeasy.rules.support.ConditionalRuleGroup;
import org.jeasy.rules.support.RuleDefinition;
import org.jeasy.rules.support.UnitRuleGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleFactory<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRuleFactory.class);
    private static final List<String> ALLOWED_COMPOSITE_RULE_TYPES = Arrays.asList(UnitRuleGroup.class.getSimpleName(), ConditionalRuleGroup.class.getSimpleName(), ActivationRuleGroup.class.getSimpleName());

    protected Rule createRule(RuleDefinition ruleDefinition, C context) {
        if (ruleDefinition.isCompositeRule()) {
            return this.createCompositeRule(ruleDefinition, context);
        }
        return this.createSimpleRule(ruleDefinition, context);
    }

    protected abstract Rule createSimpleRule(RuleDefinition var1, C var2);

    protected Rule createCompositeRule(RuleDefinition ruleDefinition, C parserContext) {
        CompositeRule compositeRule;
        if (ruleDefinition.getCondition() != null) {
            LOGGER.warn("Condition '{}' in composite rule '{}' of type {} will be ignored.", new Object[]{ruleDefinition.getCondition(), ruleDefinition.getName(), ruleDefinition.getCompositeRuleType()});
        }
        if (ruleDefinition.getActions() != null && !ruleDefinition.getActions().isEmpty()) {
            LOGGER.warn("Actions '{}' in composite rule '{}' of type {} will be ignored.", new Object[]{ruleDefinition.getActions(), ruleDefinition.getName(), ruleDefinition.getCompositeRuleType()});
        }
        String name = ruleDefinition.getName();
        switch (ruleDefinition.getCompositeRuleType()) {
            case "UnitRuleGroup": {
                compositeRule = new UnitRuleGroup(name);
                break;
            }
            case "ActivationRuleGroup": {
                compositeRule = new ActivationRuleGroup(name);
                break;
            }
            case "ConditionalRuleGroup": {
                compositeRule = new ConditionalRuleGroup(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid composite rule type, must be one of " + ALLOWED_COMPOSITE_RULE_TYPES);
            }
        }
        compositeRule.setDescription(ruleDefinition.getDescription());
        compositeRule.setPriority(ruleDefinition.getPriority());
        for (RuleDefinition composingRuleDefinition : ruleDefinition.getComposingRules()) {
            compositeRule.addRule(this.createRule(composingRuleDefinition, parserContext));
        }
        return compositeRule;
    }
}

