/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.states.core;

import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jeasy.states.api.FiniteStateMachine;
import org.jeasy.states.api.State;
import org.jeasy.states.api.Transition;
import org.jeasy.states.core.FiniteStateMachineDefinitionValidator;
import org.jeasy.states.core.FiniteStateMachineImpl;
import org.jeasy.states.core.TransitionDefinitionValidator;

public class FiniteStateMachineBuilder {
    private static final Logger LOGGER = Logger.getLogger(FiniteStateMachineBuilder.class.getName());
    private FiniteStateMachineImpl finiteStateMachine;
    private FiniteStateMachineDefinitionValidator finiteStateMachineDefinitionValidator;
    private TransitionDefinitionValidator transitionDefinitionValidator;

    public FiniteStateMachineBuilder(Set<State> states, State initialState) {
        this.finiteStateMachine = new FiniteStateMachineImpl(states, initialState);
        this.finiteStateMachineDefinitionValidator = new FiniteStateMachineDefinitionValidator();
        this.transitionDefinitionValidator = new TransitionDefinitionValidator();
    }

    public FiniteStateMachineBuilder registerTransition(Transition transition) {
        this.transitionDefinitionValidator.validateTransitionDefinition(transition, this.finiteStateMachine);
        this.finiteStateMachine.registerTransition(transition);
        return this;
    }

    public FiniteStateMachineBuilder registerTransitions(Set<Transition> transitions) {
        for (Transition transition : transitions) {
            this.registerTransition(transition);
        }
        return this;
    }

    public FiniteStateMachineBuilder registerFinalState(State finalState) {
        this.finiteStateMachine.registerFinalState(finalState);
        return this;
    }

    public FiniteStateMachineBuilder registerFinalStates(Set<State> finalStates) {
        for (State finalState : finalStates) {
            this.registerFinalState(finalState);
        }
        return this;
    }

    public FiniteStateMachine build() {
        this.finiteStateMachineDefinitionValidator.validateFiniteStateMachineDefinition(this.finiteStateMachine);
        return this.finiteStateMachine;
    }

    static {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(FiniteStateMachineBuilder.class.getResourceAsStream("/logging.properties"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load log configuration file", e);
        }
    }
}

