/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.html.helper;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.util.PoiPublicUtil;

public class StylerHelper {
    private static String DEFAULTS_CLASS_CSS = ".excelDefaults {background-color: white;color: black;text-decoration: none;direction: ltr;text-transform: none;text-indent: 0;letter-spacing: 0;word-spacing: 0;white-space: normal;unicode-bidi: normal;vertical-align: 0;text-shadow: none;padding: 0;margin: 0;border-collapse: collapse;white-space: pre-wrap;word-wrap: break-word;word-break: break-all;}.excelDefaults td {padding: 1px 5px;border: 1px solid silver;border-color: #000000;text-align: center;vertical-align: middle;font-size: 12pt;}.excelDefaults .colHeader {background-color: silver;font-weight: bold;border: 1px solid black;text-align: center;padding: 1px 5px;}.excelDefaults .rowHeader {background-color: silver;font-weight: bold;border: 1px solid black;text-align: right;padding: 1px 5px;}";
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private static final Map<Short, String> ALIGN = PoiPublicUtil.mapFor(HorizontalAlignment.LEFT.getCode(), "left", HorizontalAlignment.CENTER.getCode(), "center", HorizontalAlignment.RIGHT.getCode(), "right", HorizontalAlignment.FILL.getCode(), "left", HorizontalAlignment.JUSTIFY.getCode(), "left", HorizontalAlignment.CENTER_SELECTION.getCode(), "center");
    private static final Map<Short, String> VERTICAL_ALIGN = PoiPublicUtil.mapFor(VerticalAlignment.BOTTOM.getCode(), "bottom", VerticalAlignment.CENTER.getCode(), "middle", VerticalAlignment.TOP.getCode(), "top");
    private Formatter out;
    private Sheet sheet;
    private HtmlHelper helper;
    private int sheetNum;
    private int cssRandom;

    public StylerHelper(Workbook wb, Formatter out, int sheetNum, int cssRandom) {
        this.out = out;
        this.sheetNum = sheetNum;
        this.cssRandom = cssRandom;
        if (wb instanceof HSSFWorkbook) {
            this.helper = new HSSFHtmlHelper((HSSFWorkbook)wb);
        } else if (wb instanceof XSSFWorkbook) {
            this.helper = new XSSFHtmlHelper((XSSFWorkbook)wb);
        } else {
            throw new IllegalArgumentException("unknown workbook type: " + wb.getClass().getSimpleName());
        }
        this.printInlineStyle(wb);
    }

    private void printInlineStyle(Workbook wb) {
        this.out.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles(wb);
        this.prontFonts(wb);
        this.out.format("</style>%n", new Object[0]);
    }

    private void prontFonts(Workbook wb) {
        short le = wb.getNumberOfFonts();
        for (short i = 0; i <= le; i = (short)(i + 1)) {
            Font font = wb.getFontAt(i);
            this.out.format(".%s .%s {%n", DEFAULTS_CLASS, "font_" + i + "_" + this.cssRandom);
            this.fontStyle(font);
            this.out.format("}%n", new Object[0]);
        }
    }

    public void printStyles(Workbook wb) {
        if (DEFAULTS_CLASS_CSS == null) {
            DEFAULTS_CLASS_CSS = this.getDefaultsClassCss();
        }
        this.out.format(DEFAULTS_CLASS_CSS, new Object[0]);
        HashSet<CellStyle> seen = new HashSet<CellStyle>();
        this.sheet = wb.getSheetAt(this.sheetNum);
        Iterator rows = this.sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            for (Cell cell : row) {
                CellStyle style = cell.getCellStyle();
                if (seen.contains(style)) continue;
                this.printStyle(style);
                seen.add(style);
            }
        }
    }

    private String getDefaultsClassCss() {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(StylerHelper.class.getResourceAsStream("excelStyle.css")));
            while ((line = in.readLine()) != null) {
                formatter.format("%s%n", line);
            }
            String string = formatter.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading standard css", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Reading standard css", e);
                }
            }
            formatter.close();
        }
    }

    private void printStyle(CellStyle style) {
        this.out.format(".%s .%s {%n", DEFAULTS_CLASS, this.styleName(style));
        this.styleContents(style);
        this.out.format("}%n", new Object[0]);
    }

    private void styleContents(CellStyle style) {
        if (style.getAlignmentEnum().getCode() != 2) {
            this.styleOut("text-align", style.getAlignmentEnum().getCode(), ALIGN);
            this.styleOut("vertical-align", style.getAlignmentEnum().getCode(), VERTICAL_ALIGN);
        }
        this.helper.colorStyles(style, this.out);
    }

    private void fontStyle(Font font) {
        if (font.getBold()) {
            this.out.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.getItalic()) {
            this.out.format("  font-style: italic;%n", new Object[0]);
        }
        this.out.format("  font-family: %s;%n", font.getFontName());
        int fontheight = font.getFontHeightInPoints();
        if (fontheight == 9) {
            fontheight = 10;
        }
        this.out.format("  font-size: %dpt;%n", fontheight);
        this.helper.styleColor(this.out, "color", this.getColor(font));
    }

    private org.apache.poi.ss.usermodel.Color getColor(Font font) {
        if (this.helper instanceof HSSFHtmlHelper) {
            return ((HSSFWorkbook)this.sheet.getWorkbook()).getCustomPalette().getColor(font.getColor());
        }
        return ((XSSFFont)font).getXSSFColor();
    }

    private String styleName(CellStyle style) {
        if (style == null) {
            return "";
        }
        return String.format("style_%02x_%s", style.getIndex(), this.cssRandom);
    }

    private <K> void styleOut(String attr, K key, Map<K, String> mapping) {
        String value = mapping.get(key);
        if (value != null) {
            this.out.format("  %s: %s;%n", attr, value);
        }
    }

    private class XSSFHtmlHelper
    implements HtmlHelper {
        public XSSFHtmlHelper(XSSFWorkbook wb) {
        }

        @Override
        public void colorStyles(CellStyle style, Formatter out) {
            XSSFCellStyle cs = (XSSFCellStyle)style;
            this.styleColor(out, "background-color", (org.apache.poi.ss.usermodel.Color)cs.getFillForegroundXSSFColor());
            this.styleColor(out, "color", (org.apache.poi.ss.usermodel.Color)cs.getFont().getXSSFColor());
        }

        @Override
        public void styleColor(Formatter out, String attr, org.apache.poi.ss.usermodel.Color color) {
            XSSFColor xSSFColor = (XSSFColor)color;
            if (color == null || xSSFColor.isAuto()) {
                return;
            }
            byte[] rgb = xSSFColor.getRGB();
            if (rgb == null) {
                return;
            }
            out.format("  %s: #%02x%02x%02x;%n", attr, rgb[0], rgb[1], rgb[2]);
        }
    }

    private class HSSFHtmlHelper
    implements HtmlHelper {
        private final HSSFWorkbook wb;
        private final HSSFPalette colors;
        private HSSFColor HSSF_AUTO = new HSSFColor(64, -1, Color.black);

        public HSSFHtmlHelper(HSSFWorkbook wb) {
            this.wb = wb;
            this.colors = wb.getCustomPalette();
        }

        @Override
        public void colorStyles(CellStyle style, Formatter out) {
            HSSFCellStyle cs = (HSSFCellStyle)style;
            out.format("  /* fill pattern = %d */%n", cs.getFillPattern());
            this.styleColor(out, "background-color", cs.getFillForegroundColor());
            this.styleColor(out, "color", (org.apache.poi.ss.usermodel.Color)this.colors.getColor(cs.getFont((Workbook)this.wb).getColor()));
        }

        private void styleColor(Formatter out, String attr, short index) {
            HSSFColor color = this.colors.getColor(index);
            if (index == this.HSSF_AUTO.getIndex() || color == null) {
                out.format("  /* %s: index = %d */%n", attr, index);
            } else {
                short[] rgb = color.getTriplet();
                out.format("  %s: #%02x%02x%02x; /* index = %d */%n", attr, rgb[0], rgb[1], rgb[2], index);
            }
        }

        @Override
        public void styleColor(Formatter out, String attr, org.apache.poi.ss.usermodel.Color color) {
            if (color == null) {
                return;
            }
            HSSFColor hSSFColor = (HSSFColor)color;
            short[] rgb = hSSFColor.getTriplet();
            out.format("  %s: #%02x%02x%02x; %n", attr, rgb[0], rgb[1], rgb[2]);
        }
    }

    private static interface HtmlHelper {
        public void colorStyles(CellStyle var1, Formatter var2);

        public void styleColor(Formatter var1, String var2, org.apache.poi.ss.usermodel.Color var3);
    }
}

