/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.websocket;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.jeecg.common.base.BaseMap;
import org.jeecg.common.modules.redis.client.JeecgRedisClient;
import org.jeecg.common.modules.redis.listener.JeecgRedisListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dragWebSocket")
@ServerEndpoint(value="/websocket/drag/{chartId}")
public class DragWebSocket {
    private static final Logger log = LoggerFactory.getLogger(DragWebSocket.class);
    private static ConcurrentHashMap<String, Session> sessionPool = new ConcurrentHashMap();
    public static final String REDIS_TOPIC_NAME = "dragSocketHandler";
    @Autowired
    private JeecgRedisClient jeecgRedisClient;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="chartId") String chartId) {
        try {
            sessionPool.put(chartId, session);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnClose
    public void onClose(@PathParam(value="chartId") String chartId) {
        try {
            sessionPool.remove(chartId);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(String chartId, String message) {
        for (Map.Entry<String, Session> entry : sessionPool.entrySet()) {
            if (!entry.getKey().contains(chartId)) continue;
            Session session = entry.getValue();
            try {
                Session session2 = session;
                synchronized (session2) {
                    log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u63a8\u9001\u5355\u4eba\u6d88\u606f:" + message);
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @OnMessage
    public void onMessage(String message) {
        if (!"ping".equals(message) && !"heartcheck".equals(message)) {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        } else {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        log.warn("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6d88\u606f\u51fa\u73b0\u9519\u8bef");
        t.printStackTrace();
    }

    public void sendMessage(String chartId, String message) {
        BaseMap baseMap = new BaseMap();
        baseMap.put("chartId", (Object)chartId);
        baseMap.put("message", (Object)message);
        this.jeecgRedisClient.sendMessage(REDIS_TOPIC_NAME, baseMap);
    }

    @Component(value="dragSocketHandler")
    class RedisSocketHandler
    implements JeecgRedisListener {
        private final DragWebSocket dragWebSocket;

        public RedisSocketHandler(DragWebSocket dragWebSocket) {
            this.dragWebSocket = dragWebSocket;
        }

        public void onMessage(BaseMap map) {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011redis {}\uff0c\u53c2\u6570\uff1a{}", (Object)DragWebSocket.REDIS_TOPIC_NAME, (Object)map.toString());
            String string = (String)map.get("chartId");
            String string2 = (String)map.get("message");
            this.dragWebSocket.pushMessage(string, string2);
        }
    }
}

