/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.Query;
import com.kingbase8.util.CanEstimateSize;
import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;

public class CachedQuery
implements CanEstimateSize {
    public final Object _key;
    public final Query query;
    public final boolean isFunction;
    public final boolean outParmBeforeFunc;
    public final String schemaName;
    public final String funName;
    public final String origFuncName;
    private int _executeCount;

    public CachedQuery(Object _key, Query query, boolean isFunction, boolean outParmBeforeFunc, String schemaName, String funName, String origFuncName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        assert (_key instanceof String || _key instanceof CanEstimateSize) : "CachedQuery._key should either be String or implement CanEstimateSize. Actual class is " + _key.getClass();
        this._key = _key;
        this.query = query;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.isFunction = isFunction;
        this.outParmBeforeFunc = outParmBeforeFunc;
        this.schemaName = schemaName;
        this.funName = funName;
        this.origFuncName = origFuncName;
    }

    public void increaseExecuteCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._executeCount < Integer.MAX_VALUE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++this._executeCount;
        }
    }

    public void increaseExecuteCount(int inc) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int newValue = this._executeCount + inc;
        if (newValue > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._executeCount = newValue;
        }
    }

    public int getExecuteCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._executeCount;
    }

    @Override
    public long getSize() {
        long queryLength;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._key instanceof String) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            queryLength = (long)((String)this._key).length() * 2L;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            queryLength = ((CanEstimateSize)this._key).getSize();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return queryLength * 2L + 100L;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "CachedQuery{executeCount=" + this._executeCount + ", query=" + this.query + ", isFunction=" + this.isFunction + ", outParmBeforeFunc=" + this.outParmBeforeFunc + '}';
    }
}

