/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.core.KBStream;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.Utils;
import com.kingbase8.core.v3.TypeTransferModeRegistry;
import com.kingbase8.core.v3.V3ParameterList;
import com.kingbase8.geometric.KBbox;
import com.kingbase8.geometric.KBpoint;
import com.kingbase8.jdbc.UUIDArrayAssistant;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.StreamWrapper;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;

class SimpleParameterList
implements V3ParameterList {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    public static final byte OUTPARMBEFOREFUNC = 8;
    private static final byte TEXT = 0;
    private static final byte BINARY = 4;
    public static final int INPARM = 0x20000000;
    public static final int OUTPARM = 0x40000000;
    public static final int OUTPARMBEFOREFUNCPARM = Integer.MIN_VALUE;
    private final Object[] _paramValues;
    private final int[] _paramTypes;
    private final byte[] _flags;
    private final byte[][] _encoded;
    private final TypeTransferModeRegistry transferModeRegistry;
    private static final Object NULL_OBJECT = new Object();
    private int position = 0;

    SimpleParameterList(int _paramCount, TypeTransferModeRegistry transferModeRegistry) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._paramValues = new Object[_paramCount];
        this._paramTypes = new int[_paramCount];
        this._encoded = new byte[_paramCount][];
        this._flags = new byte[_paramCount];
        this.transferModeRegistry = transferModeRegistry;
    }

    @Override
    public void registerOutParameter(int _index, int oid, boolean outParmBeforeFunc) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_index < 1 || _index > this._paramValues.length) {
            throw new KSQLException(GT.tr("The _column _index is out of range: {0}, number of _columns: {1}.", _index, this._paramValues.length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int n = --_index;
        this._flags[n] = (byte)(this._flags[n] | 2);
        if ("oracle".equals(((QueryExecutor)this.transferModeRegistry).getCompatibleLevel()) || "mysql".equals(((QueryExecutor)this.transferModeRegistry).getCompatibleLevel())) {
            if (this._paramValues[_index] == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._paramValues[_index] = NULL_OBJECT;
            }
            this._paramTypes[_index] = oid;
            if (outParmBeforeFunc && _index == 0) {
                int n2 = _index;
                this._flags[n2] = (byte)(this._flags[n2] | 8);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.position = _index + 1;
    }

    private void bind(int _index, Object _value, int oid, byte binary) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_index < 1 || _index > this._paramValues.length) {
            throw new KSQLException(GT.tr("The _column _index is out of range: {0}, number of _columns: {1}.", _index, this._paramValues.length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encoded[--_index] = null;
        this._paramValues[_index] = _value;
        this._flags[_index] = (byte)(this.direction(_index) | 1 | binary);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (oid == 0 && this._paramTypes[_index] != 0 && _value == NULL_OBJECT) {
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._paramTypes[_index] = oid;
        this.position = _index + 1;
    }

    @Override
    public int getParameterCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._paramValues.length;
    }

    @Override
    public int getOutParameterCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _count = 0;
        for (int i = 0; i < this._paramTypes.length; ++i) {
            if ((this.direction(i) & 2) != 2) continue;
            ++_count;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_count == 0) {
            _count = 1;
        }
        return _count;
    }

    @Override
    public int getInParameterCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _count = 0;
        for (int i = 0; i < this._paramTypes.length; ++i) {
            if (this.direction(i) == 2) continue;
            ++_count;
        }
        return _count;
    }

    @Override
    public void setIntParameter(int _index, int _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] data = new byte[4];
        ByteConverter.int4(data, 0, _value);
        this.bind(_index, data, 23, (byte)4);
    }

    @Override
    public void setLiteralParameter(int _index, String _value, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, _value, oid, (byte)0);
    }

    @Override
    public void setStringParameter(int _index, String _value, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, _value, oid, (byte)0);
    }

    @Override
    public void setBinaryParameter(int _index, byte[] _value, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, _value, oid, (byte)4);
    }

    @Override
    public void setBytea(int _index, byte[] data, int _offset, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, new StreamWrapper(data, _offset, length), 17, (byte)4);
    }

    @Override
    public void setBytea(int _index, InputStream stream, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, new StreamWrapper(stream, length), 17, (byte)4);
    }

    @Override
    public void setBytea(int _index, InputStream stream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, new StreamWrapper(stream), 17, (byte)4);
    }

    @Override
    public void setText(int _index, InputStream stream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, new StreamWrapper(stream), 25, (byte)0);
    }

    @Override
    public void setNull(int _index, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte binaryTransfer = 0;
        if (this.transferModeRegistry.useBinaryForReceive(oid)) {
            binaryTransfer = 4;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.bind(_index, NULL_OBJECT, oid, binaryTransfer);
    }

    @Override
    public String toString(int _index, boolean standardConformingStrings) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._paramValues[--_index] == null) {
            return "?";
        }
        if (this._paramValues[_index] == NULL_OBJECT) {
            return "NULL";
        }
        if ((this._flags[_index] & 4) == 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            switch (this._paramTypes[_index]) {
                case 7014: 
                case 8100: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte b = ByteConverter.int1((byte[])this._paramValues[_index], 0);
                    return Byte.toString(b);
                }
                case 21: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    short s = ByteConverter.int2((byte[])this._paramValues[_index], 0);
                    return Short.toString(s);
                }
                case 23: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int i = ByteConverter.int4((byte[])this._paramValues[_index], 0);
                    return Integer.toString(i);
                }
                case 20: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    long l = ByteConverter.int8((byte[])this._paramValues[_index], 0);
                    return Long.toString(l);
                }
                case 700: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    float f = ByteConverter.float4((byte[])this._paramValues[_index], 0);
                    if (Float.isNaN(f)) {
                        return "'NaN'::real";
                    }
                    return Float.toString(f);
                }
                case 701: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    double d = ByteConverter.float8((byte[])this._paramValues[_index], 0);
                    if (Double.isNaN(d)) {
                        return "'NaN'::double precision";
                    }
                    return Double.toString(d);
                }
                case 2950: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    String uuid = new UUIDArrayAssistant().buildElement((byte[])this._paramValues[_index], 0, 16).toString();
                    return "'" + uuid + "'::uuid";
                }
                case 600: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBpoint pgPoint = new KBpoint();
                    pgPoint.setByteValue((byte[])this._paramValues[_index], 0);
                    return "'" + pgPoint.toString() + "'::point";
                }
                case 603: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    KBbox pgBox = new KBbox();
                    pgBox.setByteValue((byte[])this._paramValues[_index], 0);
                    return "'" + pgBox.toString() + "'::box";
                }
            }
            return "?";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _param = this._paramValues[_index].toString();
        StringBuilder p = new StringBuilder(3 + (_param.length() + 10) / 10 * 11);
        p.append('\'');
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            p = Utils.escapeLiteral(p, _param, standardConformingStrings);
        }
        catch (SQLException _sqle) {
            p.append(_param);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        p.append('\'');
        int _paramType = this._paramTypes[_index];
        if (_paramType == 1114) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            p.append("::timestamp");
        } else if (_paramType == 1184) {
            p.append("::timestamp with time zone");
        } else if (_paramType == 1083) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            p.append("::time");
        } else if (_paramType == 1266) {
            p.append("::time with time zone");
        } else if (_paramType == 1082) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            p.append("::date");
        } else if (_paramType == 1186) {
            p.append("::interval");
        } else if (_paramType == 1700) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!"mysql".equals(((QueryExecutor)this.transferModeRegistry).getCompatibleLevel())) {
                p.append("::numeric");
            }
        }
        return p.toString();
    }

    @Override
    public void checkAllParametersSet() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < this._paramTypes.length; ++i) {
            if (this.direction(i) == 2 || this._paramValues[i] != null) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No _value specified for _parameter {0}.", i + 1), KSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void convertFunctionOutParameters() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < this._paramTypes.length; ++i) {
            if (this.direction(i) != 2) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._paramTypes[i] = 2278;
            this._paramValues[i] = "null";
        }
    }

    private static void streamBytea(KBStream kbStream, StreamWrapper wrapper) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            kbStream.send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        kbStream.sendStream(wrapper.getStream(), wrapper.getLength());
    }

    @Override
    public int[] getTypeOIDs() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._paramTypes;
    }

    int getTypeOID(int _index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._paramTypes[_index - 1];
    }

    boolean hasUnresolvedTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int _paramType : this._paramTypes) {
            if (_paramType != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(int _index, int oid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._paramTypes[_index - 1] == 0) {
            this._paramTypes[_index - 1] = oid;
        } else if (this._paramTypes[_index - 1] != oid) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("Can't change resolved type for _param: " + _index + " from " + this._paramTypes[_index - 1] + " to " + oid);
        }
    }

    boolean isNull(int _index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._paramValues[_index - 1] == NULL_OBJECT;
    }

    boolean isBinary(int _index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (this._flags[_index - 1] & 4) != 0;
    }

    private byte direction(int _index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (byte)(this._flags[_index] & 3);
    }

    int getV3Length(int _index, String _encoding) throws UnsupportedEncodingException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._paramValues[--_index] == NULL_OBJECT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("can't getV3Length() on a null _parameter");
        }
        if (this._paramValues[_index] instanceof byte[]) {
            return ((byte[])this._paramValues[_index]).length;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._paramValues[_index] instanceof StreamWrapper) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ((StreamWrapper)this._paramValues[_index]).getLength();
        }
        if (this._encoded[_index] == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._encoded[_index] = Utils.encode(this._paramValues[_index].toString(), _encoding);
        }
        return this._encoded[_index].length;
    }

    void writeV3Value(int _index, KBStream kbStream, String _encoding) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._paramValues[--_index] == NULL_OBJECT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalArgumentException("can't writeV3Value() on a null _parameter");
        }
        if (this._paramValues[_index] instanceof byte[]) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            kbStream.send((byte[])this._paramValues[_index]);
            return;
        }
        if (this._paramValues[_index] instanceof StreamWrapper) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            SimpleParameterList.streamBytea(kbStream, (StreamWrapper)this._paramValues[_index]);
            return;
        }
        if (this._encoded[_index] == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._encoded[_index] = Utils.encode((String)this._paramValues[_index], _encoding);
        }
        kbStream.send(this._encoded[_index]);
    }

    @Override
    public ParameterList copy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleParameterList newCopy = new SimpleParameterList(this._paramValues.length, this.transferModeRegistry);
        System.arraycopy(this._paramValues, 0, newCopy._paramValues, 0, this._paramValues.length);
        System.arraycopy(this._paramTypes, 0, newCopy._paramTypes, 0, this._paramTypes.length);
        System.arraycopy(this._flags, 0, newCopy._flags, 0, this._flags.length);
        newCopy.position = this.position;
        return newCopy;
    }

    @Override
    public void clear() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Arrays.fill(this._paramValues, null);
        Arrays.fill(this._paramTypes, 0);
        Arrays.fill((Object[])this._encoded, null);
        Arrays.fill(this._flags, (byte)0);
        this.position = 0;
    }

    @Override
    public SimpleParameterList[] getSub_params() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public Object[] getValues() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._paramValues;
    }

    @Override
    public int[] getParamTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._paramTypes;
    }

    @Override
    public byte[] getFlags() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._flags;
    }

    @Override
    public byte[][] getEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._encoded;
    }

    @Override
    public void appendAll(ParameterList list) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (list instanceof SimpleParameterList) {
            SimpleParameterList spl = (SimpleParameterList)list;
            int inParamCount = spl.getInParameterCount();
            if (this.position + inParamCount > this._paramValues.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("Added _parameters _index out of range: {0}, number of _columns: {1}.", this.position + inParamCount, this._paramValues.length), KSQLState.INVALID_PARAMETER_VALUE);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            System.arraycopy(spl.getValues(), 0, this._paramValues, this.position, inParamCount);
            System.arraycopy(spl.getParamTypes(), 0, this._paramTypes, this.position, inParamCount);
            System.arraycopy(spl.getFlags(), 0, this._flags, this.position, inParamCount);
            System.arraycopy(spl.getEncoding(), 0, this._encoded, this.position, inParamCount);
            this.position += inParamCount;
        }
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder ts = new StringBuilder("<[");
        if (this._paramValues.length > 0) {
            ts.append(this.toString(1, true));
            for (int c = 2; c <= this._paramValues.length; ++c) {
                ts.append(" ,").append(this.toString(c, true));
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ts.append("]>");
        return ts.toString();
    }
}

