/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.pagehelper.dialect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jeecgframework.minidao.pagehelper.PageException;
import org.jeecgframework.minidao.pagehelper.dialect.AbstractHelperDialect;
import org.jeecgframework.minidao.pagehelper.dialect.Dialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.Db2Dialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.HerdDBDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.HsqldbDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.InformixDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.MySqlDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.Oracle9iDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.OracleDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.OscarDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.PostgreSqlDialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.SqlServer2012Dialect;
import org.jeecgframework.minidao.pagehelper.dialect.helper.SqlServerDialect;

public class PageAutoDialect {
    private static Map<String, Class<? extends Dialect>> dialectAliasMap = new HashMap<String, Class<? extends Dialect>>();
    private boolean multiDialect = false;
    private boolean closeConn = true;
    private AbstractHelperDialect delegate;
    private Map<String, AbstractHelperDialect> urlDialectMap = new ConcurrentHashMap<String, AbstractHelperDialect>();
    private ThreadLocal<AbstractHelperDialect> dialectThreadLocal = new ThreadLocal();
    private ReentrantLock lock = new ReentrantLock();

    public static void registerDialectAlias(String alias, Class<? extends Dialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public void initDelegateDialect(DataSource dataSource) {
        if (this.multiDialect) {
            this.dialectThreadLocal.set(this.getDialect(dataSource));
        } else if (this.delegate == null) {
            this.delegate = this.getDialect(dataSource);
        }
    }

    public AbstractHelperDialect getDelegate() {
        if (this.multiDialect) {
            return this.dialectThreadLocal.get();
        }
        return this.delegate;
    }

    public String getDialectKeyByJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        for (String dialect : dialectAliasMap.keySet()) {
            if (!url.contains(":" + dialect.toLowerCase() + ":")) continue;
            return dialect;
        }
        return null;
    }

    private Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return null;
    }

    private AbstractHelperDialect initDialect(String dialectKey) {
        AbstractHelperDialect dialect;
        if (StringUtils.isBlank((CharSequence)dialectKey)) {
            throw new PageException("\u4f7f\u7528\u5206\u9875\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e helper \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = this.resloveDialectClass(dialectKey);
            if (!AbstractHelperDialect.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("\u65b9\u8a00\u5fc5\u987b\u662f\u5b9e\u73b0 " + AbstractHelperDialect.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5b9e\u73b0\u7c7b!");
            }
            dialect = (AbstractHelperDialect)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("\u521d\u59cb\u5316 helper [" + dialectKey + "]\u65f6\u51fa\u9519:" + e.getMessage(), e);
        }
        return dialect;
    }

    private String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException(e);
        }
        finally {
            if (conn != null) {
                try {
                    if (this.closeConn) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractHelperDialect getDialect(DataSource dataSource) {
        String url = this.getUrl(dataSource);
        if (this.urlDialectMap.containsKey(url)) {
            return this.urlDialectMap.get(url);
        }
        try {
            this.lock.lock();
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl");
            }
            String dialectKey = this.getDialectKeyByJdbcUrl(url);
            if (dialectKey == null) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b");
            }
            AbstractHelperDialect dialect = this.initDialect(dialectKey);
            this.urlDialectMap.put(url, dialect);
            AbstractHelperDialect abstractHelperDialect = dialect;
            return abstractHelperDialect;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractHelperDialect getDialect(String dbUrl) {
        if (this.urlDialectMap.containsKey(dbUrl)) {
            return this.urlDialectMap.get(dbUrl);
        }
        try {
            this.lock.lock();
            if (StringUtils.isBlank((CharSequence)dbUrl)) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl");
            }
            String dialectStr = this.getDialectKeyByJdbcUrl(dbUrl);
            if (dialectStr == null) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b");
            }
            AbstractHelperDialect dialect = this.initDialect(dialectStr);
            this.urlDialectMap.put(dbUrl, dialect);
            AbstractHelperDialect abstractHelperDialect = dialect;
            return abstractHelperDialect;
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        PageAutoDialect.registerDialectAlias("hsqldb", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("h2", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("phoenix", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("highgo", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("xugu", HsqldbDialect.class);
        PageAutoDialect.registerDialectAlias("postgresql", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("kingbase", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("kingbase8", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("zenith", PostgreSqlDialect.class);
        PageAutoDialect.registerDialectAlias("mysql", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("mariadb", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("polardb", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("sqlite", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("clickhouse", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("taos", MySqlDialect.class);
        PageAutoDialect.registerDialectAlias("herddb", HerdDBDialect.class);
        PageAutoDialect.registerDialectAlias("oracle", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("oracle9i", Oracle9iDialect.class);
        PageAutoDialect.registerDialectAlias("dm", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("edb", OracleDialect.class);
        PageAutoDialect.registerDialectAlias("db2", Db2Dialect.class);
        PageAutoDialect.registerDialectAlias("informix", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("informix-sqli", InformixDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver", SqlServerDialect.class);
        PageAutoDialect.registerDialectAlias("sqlserver2012", SqlServer2012Dialect.class);
        PageAutoDialect.registerDialectAlias("derby", SqlServer2012Dialect.class);
        PageAutoDialect.registerDialectAlias("oscar", OscarDialect.class);
    }
}

