/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.auth;

import com.alibaba.nacos.api.config.remote.request.ConfigBatchListenRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.auth.parser.ResourceParser;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.common.utils.ReflectUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ConfigResourceParser
implements ResourceParser {
    private static final String AUTH_CONFIG_PREFIX = "config/";

    public String parseName(Object requestObj) {
        String namespaceId = null;
        String groupName = null;
        String dataId = null;
        if (requestObj instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)requestObj;
            namespaceId = NamespaceUtil.processNamespaceParameter((String)req.getParameter("tenant"));
            groupName = req.getParameter("group");
            dataId = req.getParameter("dataId");
        } else if (requestObj instanceof Request) {
            Request request = (Request)requestObj;
            if (request instanceof ConfigBatchListenRequest) {
                List configListenContexts = ((ConfigBatchListenRequest)request).getConfigListenContexts();
                if (!configListenContexts.isEmpty()) {
                    namespaceId = ((ConfigBatchListenRequest.ConfigListenContext)((ConfigBatchListenRequest)request).getConfigListenContexts().get(0)).getTenant();
                }
            } else {
                namespaceId = (String)ReflectUtils.getFieldValue((Object)request, (String)"tenant", (Object)"");
            }
            groupName = (String)ReflectUtils.getFieldValue((Object)request, (String)"group", (Object)"");
            dataId = (String)ReflectUtils.getFieldValue((Object)request, (String)"dataId", (Object)"");
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)namespaceId)) {
            sb.append(namespaceId);
        }
        if (StringUtils.isBlank((CharSequence)groupName)) {
            sb.append(":").append('*');
        } else {
            sb.append(":").append(groupName);
        }
        if (StringUtils.isBlank((CharSequence)dataId)) {
            sb.append(":").append(AUTH_CONFIG_PREFIX).append('*');
        } else {
            sb.append(":").append(AUTH_CONFIG_PREFIX).append(dataId);
        }
        return sb.toString();
    }
}

