/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.auth;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.auth.RoleInfo;
import com.alibaba.nacos.config.server.auth.RolePersistService;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnExternalStorage.class})
@Component
public class ExternalRolePersistServiceImpl
implements RolePersistService {
    @Autowired
    private ExternalStoragePersistServiceImpl persistService;
    private JdbcTemplate jt;

    @PostConstruct
    protected void init() {
        this.jt = this.persistService.getJdbcTemplate();
    }

    @Override
    public Page<RoleInfo> getRoles(int pageNo, int pageSize) {
        PaginationHelper<RoleInfo> helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM (SELECT DISTINCT role FROM roles) roles WHERE ";
        String sqlFetchRows = "SELECT role,username FROM roles WHERE ";
        String where = " 1=1 ";
        try {
            Page<RoleInfo> pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, new ArrayList().toArray(), pageNo, pageSize, RowMapperManager.ROLE_INFO_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<RoleInfo> getRolesByUserName(String username, int pageNo, int pageSize) {
        PaginationHelper<RoleInfo> helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM roles WHERE ";
        String sqlFetchRows = "SELECT role,username FROM roles WHERE ";
        String where = " username= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((String)username)) {
            params = Collections.singletonList(username);
        } else {
            where = " 1=1 ";
        }
        try {
            return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.ROLE_INFO_ROW_MAPPER);
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addRole(String role, String userName) {
        String sql = "INSERT INTO roles (role, username) VALUES (?, ?)";
        try {
            this.jt.update(sql, new Object[]{role, userName});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deleteRole(String role) {
        String sql = "DELETE FROM roles WHERE role=?";
        try {
            this.jt.update(sql, new Object[]{role});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deleteRole(String role, String username) {
        String sql = "DELETE FROM roles WHERE role=? AND username=?";
        try {
            this.jt.update(sql, new Object[]{role, username});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> findRolesLikeRoleName(String role) {
        String sql = "SELECT role FROM roles WHERE role LIKE '%' ? '%'";
        List users = this.jt.queryForList(sql, (Object[])new String[]{role}, String.class);
        return users;
    }

    private static final class RoleInfoRowMapper
    implements RowMapper<RoleInfo> {
        private RoleInfoRowMapper() {
        }

        public RoleInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setRole(rs.getString("role"));
            roleInfo.setUsername(rs.getString("username"));
            return roleInfo;
        }
    }
}

