/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

class ExternalStoragePaginationHelperImpl<E>
implements PaginationHelper {
    private final JdbcTemplate jdbcTemplate;

    public ExternalStoragePaginationHelperImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.fetchPage(sqlCountRows, sqlFetchRows, args, pageNo, pageSize, (Long)null, rowMapper);
    }

    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, Long lastMaxId, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)this.jdbcTemplate.queryForObject(sqlCountRows, args, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        int startRow = (pageNo - 1) * pageSize;
        String selectSql = "";
        selectSql = this.isDerby() ? sqlFetchRows + " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY" : (lastMaxId != null ? sqlFetchRows + " AND id > " + lastMaxId + " ORDER BY id ASC LIMIT " + 0 + "," + pageSize : sqlFetchRows + " LIMIT " + startRow + "," + pageSize);
        List result = this.jdbcTemplate.query(selectSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)this.jdbcTemplate.queryForObject(sqlCountRows, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        String selectSql = sqlFetchRows;
        if (this.isDerby()) {
            selectSql = selectSql.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        }
        List result = this.jdbcTemplate.query(selectSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlCountRows, Object[] args1, String sqlFetchRows, Object[] args2, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = (Integer)this.jdbcTemplate.queryForObject(sqlCountRows, args1, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        String selectSql = sqlFetchRows;
        if (this.isDerby()) {
            selectSql = selectSql.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        }
        List result = this.jdbcTemplate.query(selectSql, args2, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Page page = new Page();
        String selectSql = sqlFetchRows;
        if (this.isDerby()) {
            selectSql = selectSql.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        }
        List result = this.jdbcTemplate.query(selectSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLimit(String sql, Object[] args) {
        String sqlUpdate = sql;
        if (this.isDerby()) {
            sqlUpdate = sqlUpdate.replaceAll("LIMIT \\?", "OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY");
        }
        try {
            this.jdbcTemplate.update(sqlUpdate, args);
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateLimitWithResponse(String sql, Object[] args) {
        String sqlUpdate = sql;
        if (this.isDerby()) {
            sqlUpdate = sqlUpdate.replaceAll("LIMIT \\?", "OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY");
        }
        try {
            int n = this.jdbcTemplate.update(sqlUpdate, args);
            return n;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    private boolean isDerby() {
        return EnvUtil.getStandaloneMode() && !PropertyUtil.isUseExternalDB() || PropertyUtil.isEmbeddedStorage();
    }
}

